/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.appclient.jws;

/**
 *Provides a convenient way to give a complete path and get back the
 *constituent context root and the remaining path.
 *
 * @author tjquinn
 */
public class WebPath {
    
    private String contextRoot;
    
    private String path;
    
    /** Creates a new instance of WebPath */
    public WebPath(String fullPath) {
        /*
         *The context root should start with a slash.  Find the first one
         *after that, which will separate the context root (for web 
         *container purposes) from the path.
         */
        int secondSlash = fullPath.indexOf('/', 1);
        if (secondSlash < 0) {
            contextRoot = fullPath;
            path = "";
        } else {
            contextRoot = fullPath.substring(0, secondSlash);
            path = fullPath.substring(secondSlash);
        }
    }

    public String contextRoot() {
        return contextRoot;
    }

    public String path() {
        return path;
    }

    public String toString() {
        return "WebPathPath: context root = \"" + contextRoot + "\", path = \"" + path + "\'";
    }
}
