/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.appverification.factory;

import com.sun.enterprise.deployment.EjbDescriptor;
import java.lang.reflect.Method;
import org.apache.catalina.InstanceEvent;

/**
 *
 * @author	Qingqing Ouyang
 */
public interface InstrumentLogger {

    public void doInstrumentForWeb (InstanceEvent event);
    public void doInstrumentForEjb (EjbDescriptor ejbDsc, Method method, Throwable exception);
    public void writeResult ();

    /**
     * write instrumentation, introspection, and verifier results.
     */
    public void writeResults();

    /**
     * the version of AVKit.
     */
    public String getVersion();

    /**
     * Upon re-deploy or un-deploy of any application, the
     * generated instrumentation data will be automatically
     * removed and the memory will be cleared.
     */
    public void handleChangeInDeployment();
}
