/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors;

import com.sun.enterprise.Switch;
import com.sun.enterprise.connectors.work.WorkManagerFactory;
import com.sun.logging.LogDomains;
import java.util.Timer;
import java.util.logging.*;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;


/**
 * BootstrapContext implementation.
 *
 * @author	Qingqing Ouyang, Binod P.G
 * @see com.sun.enterprise.connectors.work.CommonWorkManager
 * @see com.sun.enterprise.connectors.work.WorkManagerFactory
 */
public class BootstrapContextImpl implements BootstrapContext {

    //The following are not serialized with the ResourceAdapter
    private WorkManager wm;
    private XATerminator xa;
    private String moduleName;
    private String poolId;
    private static Logger logger =
        LogDomains.getLogger(LogDomains.RSR_LOGGER);

    /**
     * Constructs a <code>BootstrapContext</code> with default 
     * thread pool for work manager.
     *
     * @throws ConnectorRuntimeException If there is a failure in
     *         retrieving WorkManager.
     */
    public BootstrapContextImpl () throws ConnectorRuntimeException{
        wm = WorkManagerFactory.getWorkManager(null);
    }

    /**
     * Constructs a <code>BootstrapContext</code> with a specified
     * thread pool for work manager.
     *
     * @throws ConnectorRuntimeException If there is a failure in
     *         retrieving WorkManager.
     */
    public BootstrapContextImpl (String poolId) 
                                 throws ConnectorRuntimeException{
        this.poolId = poolId;
        wm = WorkManagerFactory.getWorkManager(poolId);
    }

    /**
     * Creates a <code>java.util.Timer</code> instance.
     * This can cause a problem, since the timer threads are not actually
     * under appserver control. We should override the timer later.
     *
     * @return <code>java.util.Timer</code> object.
     */
    public Timer createTimer() {
        return new Timer();
    }

    /**
     * Retrieves the work manager.
     *
     * @return <code>WorkManager</code> instance.
     * @see com.sun.enterprise.connectors.work.CommonWorkManager
     * @see com.sun.enterprise.connectors.work.WorkManagerFactory
     */
    public WorkManager getWorkManager() {
        if (wm == null) {
            try {
                wm = WorkManagerFactory.getWorkManager(poolId);
            } catch(Exception e) {
           	logger.log(Level.SEVERE, "workmanager.instantiation_error", e);
            }
        }
        return wm;
    }

    /**
     * Retrieves the <code>XATerminator</code> object.
     */
    public XATerminator getXATerminator() {
        if (xa == null) {
            xa = Switch.getSwitch().getTransactionManager().getXATerminator();
        }
        return xa;
    }
}
