/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.connectors;

/**
 * Class representing Connector Naming Event.<br>
 * Can be used to represent different states. Eg: Object-Bind, Object-Rebind, Object-Remove
 * @author Jagadish Ramu
 */
public class ConnectorNamingEvent{

    private String jndiName; //name of the object
    private int eventType;
    public static final int EVENT_OBJECT_REBIND = 0;


    public ConnectorNamingEvent(String jndiName, int eventType){
        this.jndiName=jndiName;
        this.eventType= eventType;
    }

    /**
     * To get JndiName of the object
     * @return   jndiName
     */
    public String getJndiName(){
        return jndiName;
    }

    /**
     * Info about the type of event that has occurred.
     * @return    eventType
     */
    public int getEventType(){
        return eventType;
    }

    /**
     * Returns the state of the object
     * @return  String
     */
    public String toString(){
        StringBuffer objectState = new StringBuffer(  "ConnectorNamingEvent : " +
                "{"+ jndiName +", " + getEventName(eventType) + "}" );

        return objectState.toString();
    }

    /**
     * returns the name of event type.
     * @param eventType
     * @return  eventName
     */
    private String getEventName(int eventType){

        String eventName = "Undefined";
        switch(eventType){
            case EVENT_OBJECT_REBIND :
                eventName= "OBJECT_REBIND_EVENT";
                break;
            default:
        }
        return eventName;
    }
}
