/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.connectors;

import java.util.ArrayList;

/**
 * Notifier for connector resource naming events
 * @author Jagadish Ramu
 */
class ConnectorResourceNamingEventNotifier implements ConnectorNamingEventNotifier{

     private ArrayList<ConnectorNamingEventListener> listeners;
     private static ConnectorResourceNamingEventNotifier notifier;

     private ConnectorResourceNamingEventNotifier(){
        listeners= new ArrayList<ConnectorNamingEventListener>();
     }

      /**
       * Returns an instance of event notifier (singleton)
       * @return  ConnectorNamingEventNotifier
       */
     public static ConnectorNamingEventNotifier getInstance(){
         if(notifier == null){
            notifier = new ConnectorResourceNamingEventNotifier();
         }
        return notifier;
     }

    /**
     * To add Listener which gets notified when the event happens
     * @param listener
     */
    public void addListener(ConnectorNamingEventListener listener){
        listeners.add(listener);
    }

    /**
     * To remove listener such that it wont be notified anymore.
     * @param listener
     */
    public void removeListener(ConnectorNamingEventListener listener){
        listeners.remove(listener);
    }

    /**
     * Notifies all the registered listeners about the naming event.
     * @param event
     */
    public void notifyListeners(ConnectorNamingEvent event){

        for(ConnectorNamingEventListener listener : listeners){
            listener.connectorNamingEventPerformed(event);
        }
    }
}
