/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors;

import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.connectors.authentication.RuntimeSecurityMap;


/** 
  * Information about the ConnectorConnectionPool. 
  * Stored inofrmation is: 
  * 1. Default Subject
  * 2. MCF Instance
  * 3. Password, UserName
  * 4. The transaction-support attribute level in case of connector
  *    connection pools
  * 5. The allow-non-component-callers, non-trasnactional-connections
  *    attribs for jdbc connection pools
  *
  * @author    Binod P.G., Aditya Gore 
  * @version 
 */

public class PoolMetaData {

    private ManagedConnectionFactory mcf = null;
    private String poolName = null;
    private Subject subj = null;
    private ResourcePrincipal prin_;
    private int txSupport_;
    private boolean isPM_ = false;
    private boolean isNonTx_ = false;
    private RuntimeSecurityMap runtimeSecurityMap;
    private boolean lazyEnlistable_ = false;
    private boolean lazyAssoc_ = false;
    private boolean isAuthCredentialsDefinedInPool_ = true;
    
    public PoolMetaData(String poolName, ManagedConnectionFactory mcf, 
                   Subject s, int txSupport, ResourcePrincipal prin,
                   boolean isPM, boolean isNonTx, boolean lazyEnlistable,
                   RuntimeSecurityMap runtimeSecurityMap, boolean lazyAssoc) {
        this.poolName = poolName;
	this.mcf = mcf;
	this.subj = s;
	txSupport_ = txSupport;
	prin_ = prin;
        isPM_ = isPM;
        isNonTx_ = isNonTx;
        lazyEnlistable_ = lazyEnlistable;
        lazyAssoc_ = lazyAssoc;
        this.runtimeSecurityMap = runtimeSecurityMap;
    }

    public ManagedConnectionFactory getMCF() {
        return this.mcf;
    }

    public Subject getSubject() {
        return this.subj;
    }

    public int getTransactionSupport() {
        return txSupport_;
    }

    public ResourcePrincipal getResourcePrincipal() {
        return prin_;
    }
    
    
    public void setIsNonTx( boolean flag ) {
        isNonTx_ = flag;
    }
    
    
    public boolean isNonTx() {
        return isNonTx_;
    }
    
    
    public void setIsPM( boolean flag ) {
        isPM_ = flag;
    }
    
    
    public boolean isPM() {
        return isPM_;
    }
    
    public RuntimeSecurityMap getRuntimeSecurityMap(){
    	return this.runtimeSecurityMap;
    }

    public void setLazyEnlistable( boolean flag ) {
        lazyEnlistable_ = flag;
    }
    
    public boolean isLazyEnlistable() {
        return lazyEnlistable_;
    }

    public void setLazyAssoc( boolean flag ) {
        lazyAssoc_ = flag;
    }
    
    public boolean isLazyAssociatable() {
        return lazyAssoc_;
    }

    public void setAuthCredentialsDefinedInPool(boolean authCred) {
        this.isAuthCredentialsDefinedInPool_ = authCred;
    }

    public boolean isAuthCredentialsDefinedInPool() {
        return this.isAuthCredentialsDefinedInPool_;
    }
   
    public String toString() {
        StringBuffer sb = new StringBuffer("PoolMetaData : " + poolName );
        sb.append( "\ntxSupport => " + txSupport_ );
        sb.append( "\nisPM_     => " + isPM_ );
        sb.append( "\nisNonTx_  => " + isNonTx_ );
        sb.append( "\nisLazyEnlistable_  => " + lazyEnlistable_ );
        sb.append( "\nisLazyAssociatable  => " + lazyAssoc_ );
        sb.append( "\nsecurityMap => " + runtimeSecurityMap.toString());
        return sb.toString();
    }
}
