/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.system;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.logging.LogDomains;

/**
 * The <code>MQJMXConnectorInfo</code> holds MBean Server connection information
 * to a SJSMQ broker instance. This API is used by the admin infrastructure for
 * performing MQ administration/configuration operations on a broker instance.
 * 
 * @author Sivakumar Thyagarajan
 * @since SJSAS 9.0
 */
public class MQJMXConnectorInfo {
    private String jmxServiceURL = null;
    private Map<String,?> jmxConnectorEnv = null;
    private String asInstanceName = null;
    private String brokerInstanceName = null;
    private String brokerType = null;
    static Logger _logger = LogDomains.getLogger(LogDomains.RSR_LOGGER);
    private JMXConnector connector = null;

    public MQJMXConnectorInfo(String asInstanceName, String brokerInstanceName,
                              String brokerType, String jmxServiceURL, 
                                       Map<String, ?> jmxConnectorEnv) {
        this.brokerInstanceName = brokerInstanceName;
        this.asInstanceName = asInstanceName;
        this.jmxServiceURL = jmxServiceURL;
        this.brokerType = brokerType;
        this.jmxConnectorEnv = jmxConnectorEnv;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "MQJMXConnectorInfo : brokerInstanceName " + 
                            brokerInstanceName + " ASInstanceName " + asInstanceName + 
                            " jmxServiceURL "  + jmxServiceURL +  " BrokerType " + brokerType 
                            + " jmxConnectorEnv " + jmxConnectorEnv);
        }
    }

    public String getBrokerInstanceName(){
        return this.brokerInstanceName;
    }

    public String getBrokerType(){
        return this.brokerType;
    }

    public String getASInstanceName(){
        return this.asInstanceName;
    }

    public String getJMXServiceURL(){
        _logger.log(Level.FINE,"MQJMXConnectorInfo :: JMXServiceURL is " + this.jmxServiceURL);
        return this.jmxServiceURL;
    }

    public Map<String, ?> getJMXConnectorEnv(){
        return this.jmxConnectorEnv;
    }
    
    /**
     * Returns an <code>MBeanServerConnection</code> representing the MQ broker instance's MBean
     * server. 
     * @return
     * @throws ConnectorRuntimeException
     */
    //XXX:Enhance to support SSL (once MQ team delivers support in the next drop)
    //XXX: Discuss how <code>ConnectionNotificationListeners</code> could 
    //be shared with the consumer of this API
    public MBeanServerConnection getMQMBeanServerConnection() throws ConnectorRuntimeException {
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, 
                "creating MBeanServerConnection to MQ JMXServer with "+getJMXServiceURL());
            }
            JMXServiceURL jmxServiceURL = new JMXServiceURL(getJMXServiceURL());
            connector = JMXConnectorFactory.connect(jmxServiceURL, this.jmxConnectorEnv);
            //XXX: Do we need to pass in a Subject? 
            MBeanServerConnection mbsc = connector.getMBeanServerConnection();
            return mbsc;
        } catch (Exception e) {
            e.printStackTrace();
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause(e);
            throw cre;
        }
    }

    public void closeMQMBeanServerConnection() throws ConnectorRuntimeException {
        try {
           if (connector != null) {
                 connector.close();
           }
        } catch (IOException e) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause(e);
            throw cre;
        }
    }
 } 
