/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.util;

import java.security.SecureClassLoader;

/**
 * ConnectorRARClassLoader finds classes and resources from a 
 * JAR file without exploding it. This uses the JarResourceExtractor
 * for finding classes and resources inside the archive
 * 
 * This classloader is _used_ only by the admin GUI to retrieve resource
 * adapter class properties without exploding the connector archive.
 *  
 * @author Sivakumar Thyagarajan
 */
public class ConnectorRARClassLoader extends SecureClassLoader{
    private JarResourceExtractor jarResources;
    
    public ConnectorRARClassLoader(String jarName, ClassLoader parent) {
        super(parent);
        // Create the JarResource and suck in the .jar file.
        jarResources = new JarResourceExtractor(jarName);
    }
    
    protected byte[] loadClassBytes(String className) {
        className = formatClassName(className);
        return (jarResources.getResource(className));
    }

    public Class findClass(String name) throws ClassNotFoundException {
        byte[] b = loadClassBytes(name);
        if (b == null) {
            throw new ClassNotFoundException(name);
        }
        return defineClass(name, b, 0, b.length);
    }

    private String formatClassName(String className) {
        return className.replace('.', '/') + ".class";
    }

    public String getResourceAsString(String raDeploymentDescPath) {
        return new String(jarResources.getResource(raDeploymentDescPath));
    }    
    
}
