/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.util;

import com.sun.enterprise.config.serverbeans.BackendPrincipal;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.connectors.authentication.RuntimeSecurityMap;
import com.sun.enterprise.connectors.authentication.EisBackendPrincipal;
import com.sun.enterprise.connectors.authentication.ConnectorSecurityMap;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import java.util.HashMap;

/** This is class performs the task of adding/deleting and updating the
 *  security maps to the connector registry.
 *  @author Srikanth P
 */

public class SecurityMapUtils {

    private static ConnectorRegistry _registry = 
                        ConnectorRegistry.getInstance();
    public static String USERMAP = "usermap";
    public static String GROUPMAP = "groupmap";

    /** Updates the registry with the security map. If a security map already
     *  exists it deletes that map completely before adding the mew security 
     *  map.
     *  @param securityMaps Array of securityMaps to be updated.
     *  @return Hash Map containing 1 - 1 mappings of principal and 
     *  		Resource Principal 
     */
  
    public static RuntimeSecurityMap processSecurityMaps(
            ConnectorSecurityMap[] securityMaps) {
        if (securityMaps == null || securityMaps.length == 0) {
            return new RuntimeSecurityMap();
        }

        HashMap userMap = new HashMap();
        HashMap groupMap = new HashMap();
        // Add user-backendPrincipal mappings to Map1
        for (int i = 0; i < securityMaps.length; i++) {
            ConnectorSecurityMap map = securityMaps[i];
            ResourcePrincipal principal = generateResourcePrincipal(map);

            String[] principalNames = map.getPrincipals();
            for (int j = 0; j < principalNames.length; j++) {
                userMap.put(principalNames[j], principal);
            }

            String[] groupNames = map.getUserGroups();
            for (int j = 0; j < groupNames.length; j++) {
                groupMap.put(groupNames[j], principal);
            }
        }

        RuntimeSecurityMap runtimeSecurityMap = new RuntimeSecurityMap(userMap,
                groupMap);

        return runtimeSecurityMap;
    }

    public static ConnectorSecurityMap[] getConnectorSecurityMaps(
            SecurityMap[] securityMaps) {

        ConnectorSecurityMap[] maps = new ConnectorSecurityMap[securityMaps.length];
        for (int i = 0; i < securityMaps.length; i++) {
            maps[i] = convertSecurityMapConfigBeanToSecurityMap(securityMaps[i]);
        }
        return maps;
    }

    private static ConnectorSecurityMap convertSecurityMapConfigBeanToSecurityMap(
            SecurityMap securityMap) {

        String name = securityMap.getName();
        String[] principal = securityMap.getPrincipal();
        String[] userGroup = securityMap.getUserGroup();
        EisBackendPrincipal backendPrincipal = transformBackendPrincipal(securityMap
                .getBackendPrincipal());
        ConnectorSecurityMap convertedSecurityMap = new ConnectorSecurityMap(
                name, principal, userGroup, backendPrincipal);

        return convertedSecurityMap;
    }

    /**
     * Creates the ResourcePrincipal object from the given securityMap 
     * @param securityMap SecurityMap
     * @return created ResourcePrincipal object
     */

    private static ResourcePrincipal generateResourcePrincipal(
                 ConnectorSecurityMap securityMap) {

        EisBackendPrincipal backendPrincipal = securityMap.getBackendPrincipal();
        String userName = backendPrincipal.getUserName();
        String password = backendPrincipal.getPassword();
        ResourcePrincipal resPrincipal = 
                      new ResourcePrincipal(userName,password);
        return resPrincipal;
    }
    
    private static EisBackendPrincipal transformBackendPrincipal(BackendPrincipal principal){
    	String userName = principal.getUserName();
        String password = principal.getPassword();
        EisBackendPrincipal backendPrincipal = 
        			  new EisBackendPrincipal(userName, password);
    	return backendPrincipal;
    }

}

