/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.backend;

import java.util.Properties;

import com.sun.enterprise.deployment.interfaces.DeploymentFactory;
import com.sun.enterprise.deployment.interfaces.DeploymentImplConstants;
import com.sun.enterprise.deployment.interfaces.ClientJarMaker;

/**
 *  Implementation of the pluggabilty layers factory for PE.
 * 
 * @author Jerome Dochez
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class PEDeploymentFactoryImpl implements DeploymentFactory {

	/**
	* hook for creating appclient container jar files.
	* @param props is a properties collection to pass implementation 
	* dependent parameters from the the requester and the implementation
	* @return an implementation of the @see ClientJarMaker 
	*  interface
	*/
	public ClientJarMaker getClientJarMaker(Properties props) {
        if (props != null) {
            boolean createSimpleClient = 
                Boolean.parseBoolean(props.getProperty(
                    DeploymentImplConstants.USE_MODULE_CLIENT_JAR_MAKER));
            if (createSimpleClient) {
                return new ModuleClientJarMaker(props);
            } else {
                return new ApplicationClientJarMaker(props);
            }
        }
        return new ClientJarMakerImpl(props);	
	}
}
