/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.client;

import com.sun.enterprise.admin.jmx.remote.DefaultConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.Iterator;

/**
 * This class defines the additional environment needed to
 * connect to a particular application server deployment
 * backend.  For now, the properties supported are specific
 * to jmx https connector.  We will extend it to support
 * jmx rmi connector when the jmx implementation is ready.
 * <br>
 * Environment supported in this class are defined by the
 * JMX connectors.  
 * @see also com.sun.enterprise.admin.jmx.remote.DefaultConfiguration
 * <br>
 * For example, to set a client trust manager, the key of env shall
 * be DefaultConfiguration.TRUST_MANAGER_PROPERTY_NAME.
 *
 * @author Qingqing Ouyang
 */
public final class ServerConnectionEnvironment extends HashMap {
    
    /** 
     * Creates a new instance of ServerConnectionEnvironment
     */
    public ServerConnectionEnvironment() {
        super();
    }
    
    /** 
     * Creates a new instance of ServerConnectionEnvironment
     */
    public ServerConnectionEnvironment(Map env) {
        super(env);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ServerConnectionEnvironments: \n");
        Iterator entries = entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = (Map.Entry) entries.next();
            buf.append("Key = " + entry.getKey());
            buf.append("    ");
            buf.append("Value = " + entry.getValue());
            buf.append(";\n");
        }

        return buf.toString();
    }
}
