/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DeploymentTargetFactory.java
 *
 * Created on April 26, 2003, 3:51 PM
 * @author  sandhyae
 * <BR> <I>$Source: /cvs/glassfish/appserv-core/src/java/com/sun/enterprise/deployment/phasing/DeploymentTargetFactory.java,v $
 *
 */

package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.pluggable.DeploymentFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;

/**
 * Interface that will be implemented by different targetfactories implemented
 * for PE/EE
 * @author  Sandhya E
 */
public abstract class DeploymentTargetFactory {

    private static DeploymentTargetFactory targetFactory;

    /**
     * This is a singleton factory for the DeploymentService implementation.  We should revisit
     * this to make sure this will work in multi-threaded environment, i.e. concurrent deployment.
     */
    public static DeploymentTargetFactory getDeploymentTargetFactory() {

        if (targetFactory != null) {
            return targetFactory;
        }

        PluggableFeatureFactory featureFactory =
            ApplicationServer.getServerContext().getPluggableFeatureFactory();
        DeploymentFactory dFactory = featureFactory.getDeploymentFactory();
        targetFactory = dFactory.createDeploymentTargetFactory();
        return targetFactory;
    }
          
    /**
     * Returns the DeploymentTarget that represents a targetName
     * @param configContext config context
     * @param targetName name of the target
     * @return DeploymentTarget
     * @throws IASDeploymentException
     */
    public abstract DeploymentTarget getTarget(ConfigContext configContext , 
            String domainName, String targetName) throws IASDeploymentException;
    
    /**
     * Returns the default target
     * @param configContext config context
     * @return DeploymentTarget
     * @throws IASDeploymentException
     */
    public abstract DeploymentTarget getTarget(ConfigContext configContext, 
            String domainName) throws IASDeploymentException; 
    
    public abstract TargetType[] getValidDeploymentTargetTypes();
}
