/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics;



import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.DomainXMLHelper;
import com.sun.enterprise.diagnostics.report.html.HTMLReportWriter;
import com.sun.logging.LogDomains;

import java.util.zip.ZipFile;
import java.util.List;
import java.util.Map;
import java.io.File;
import java.util.logging.Logger;
import java.util.logging.Level;
/**
 * DiagnosticAgent provides the main entry point to Diagnostic Service Back End.
 * 
 * @author mu125243
 */
public class PEDiagnosticAgent implements DiagnosticAgent {
    
    private static Logger logger = LogDomains.getLogger(LogDomains.ADMIN_LOGGER);
    
    /** Creates a new instance of DiagnosticAgent */
    public PEDiagnosticAgent() {
    }
    
    

    /**
     * Generates Diagnostic Report
     * @param clioptions cli options specified by the user
     * @return absolute path of zip containing diagnostic report
     * @throw DiagnosticException 
     */
    public String generateReport(Map options) throws DiagnosticException {
        if(options != null) {
            BackendObjectFactory objectFactory = getBackendObjectFactory(options);
            ReportGenerator generator = objectFactory.createReportGenerator();
            return generator.generate().getName();
        }
        throw new DiagnosticException(" Null Input for report generation");
    }
    
    /**
     * Generates Diagnostic Report
     * @param clioptions cli options specified by the user
     * @instances list of instance names for which report generation is invoked
     * @targetType type of the target for which report is being generated
     * @return absolute path of zip containing diagnostic report
     * @throw DiagnosticException 
     */
    public String generateReport(Map clioptions, List<String> instances,
            String targetType) throws DiagnosticException {
        throw new DiagnosticException("Unsupported operation");
    }
            

    /**
     * @param repositoryDir absolute path of central repository
     * @return list of attributes being masked with ****
     * @throw DiagnosticException 
     */
    public List<String> getConfidentialProperties(String repositoryDir) 
    throws DiagnosticException {
       return new DomainXMLHelper(repositoryDir).getAttrs();
    }
    
    /**
     * Delete report specified by the fileName
     * @fileName absolute path of the report to be deleted
     * @throw DiagnosticException
     */
    public void deleteReport(String fileName) throws DiagnosticException {
        if (fileName != null) {
            File file = new File(fileName);
            if(file.exists()) {
                file.delete();
            }
        }
    }
    /**
     * Returns BavkendObjectFactory
     */
    protected BackendObjectFactory getBackendObjectFactory(Map input) {
        return new PEBackendObjectFactory(input);
    }
    
    private Logger getLogger() {
        return logger;
    }
}
