/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.report.html;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

/**
 * Provide a basic implementation of a text node.
 */
public class HTMLText implements Text {
    
    
    /**
     * The text content of this node.
     */
    private String text = null;
    
    
    /**
     * Make a new text node.
     * @param text	The text.
     */
    public HTMLText(String text) {
        setValue(text);
    }


    /**
     */
    public String getValue() {
        return text;
    }


    /**
     */
    public void setValue(String text) {
        if (text == null) {
            throw new NullPointerException("Text is null.");
        }
        this.text = text;
    }


    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return Escape.getInstance().encodeEntities(text, "");
    }


    /**
     */
    public void write(Writer output) throws IOException {
        output.append(toString());
        output.flush();
    }


    /**
     */
    public void write(File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        write(fw);
        fw.close();
    }

}
