/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.iiop;

import java.io.*;

import javax.ejb.*;
import javax.ejb.spi.HandleDelegate;
import javax.naming.*;

import javax.rmi.PortableRemoteObject;
import javax.rmi.CORBA.Stub;

import com.sun.enterprise.util.ORBManager;
import org.omg.CORBA.portable.Delegate;
import com.sun.corba.ee.spi.presentation.rmi.DynamicStub;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;

/**
 * An implementation of HandleDelegate for the IIOP Protocol.
 *
 */

public final class IIOPHandleDelegate
    implements HandleDelegate
{

    public static HandleDelegate getHandleDelegate() {
        HandleDelegate handleDelegate =
            (HandleDelegate) java.security.AccessController.doPrivileged(
                new java.security.PrivilegedAction() {
                    public Object run()  {
                        try {
                            ClassLoader cl = new HandleDelegateClassLoader();
                            Class c = cl.loadClass(
                                "com.sun.enterprise.iiop.IIOPHandleDelegate");
                            return c.newInstance();
                        } catch ( Exception ex ) {
                            ex.printStackTrace();
                            return null;
                        }
                    }
                }
            );
        return handleDelegate;
    }
    
    
    public void writeEJBObject(javax.ejb.EJBObject ejbObject,
            java.io.ObjectOutputStream ostream)
        throws java.io.IOException
    {
        ostream.writeObject(ejbObject); // IIOP stubs are Serializable
    }
    
    public javax.ejb.EJBObject readEJBObject(java.io.ObjectInputStream istream)
        throws java.io.IOException, ClassNotFoundException
    {
        return (EJBObject)getStub(istream, EJBObject.class);
    }
    
    public void writeEJBHome(javax.ejb.EJBHome ejbHome,
            java.io.ObjectOutputStream ostream)
        throws java.io.IOException
    {
        ostream.writeObject(ejbHome); // IIOP stubs are Serializable
    }
    
    public javax.ejb.EJBHome readEJBHome(java.io.ObjectInputStream istream)
        throws java.io.IOException, ClassNotFoundException
    {
        return (EJBHome)getStub(istream, EJBHome.class);
    }
    
    private Object getStub(java.io.ObjectInputStream istream, Class stubClass)
        throws IOException, ClassNotFoundException
    {
        // deserialize obj
        Object obj = istream.readObject();

        if( StubAdapter.isStub(obj) ) {

            try {

                // Check if it is already connected to the ORB by getting
                // the delegate.  If BAD_OPERATION is not thrown, then the 
                // stub is connected.  This will happen if istream is an 
                // IIOP input stream.
                Delegate delegate = StubAdapter.getDelegate(obj);

            } catch(org.omg.CORBA.BAD_OPERATION bo) {
                

                // Stub is not connected. This can happen if istream is
		// not an IIOP input stream (e.g. it's a File stream).
                StubAdapter.connect
                    (obj, (com.sun.corba.ee.spi.orb.ORB) ORBManager.getORB());
            }

        } else {
            throw new IOException("Unable to create stub for class " + 
                stubClass.getName() + 
                ", object deserialized is not a CORBA object, it's type is " +
                obj.getClass().getName());
        }

        // narrow it
        Object stub = PortableRemoteObject.narrow(obj, stubClass);
     
        return stub;
    }
    
}
