/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.iiop;

import java.net.Socket;
import org.omg.PortableInterceptor.ServerRequestInfo;
import com.sun.corba.ee.spi.legacy.interceptor.RequestInfoExt;
import com.sun.corba.ee.spi.legacy.connection.Connection;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.iiop.security.ServerConnectionContext;

import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.distributedtx.J2EETransactionManagerOpt;

import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.admin.monitor.callflow.RequestType;
import com.sun.enterprise.admin.monitor.callflow.RequestInfo;
import com.sun.enterprise.admin.monitor.callflow.ContainerTypeOrApplicationType;
import com.sun.enterprise.util.ORBManager;
import java.util.logging.*;
import com.sun.logging.*;


public class ServerConnectionInterceptor extends org.omg.CORBA.LocalObject
    implements org.omg.PortableInterceptor.ServerRequestInterceptor, Comparable
{
    private static Logger _logger=null;
    static{
       _logger=LogDomains.getLogger(LogDomains.CORBA_LOGGER);
        }
    public static final String baseMsg = "ServerConnectionInterceptor";
    public int order;

    /**
     * Construct the interceptor.
     * @param the order in which the interceptor should run.
     */
    public ServerConnectionInterceptor(int order) {
	this.order = order;
    }

    public String name() { return baseMsg; }

    public void receive_request_service_contexts(ServerRequestInfo sri)
    {
        Socket s = null;
        Connection c = ((RequestInfoExt)sri).connection();
        SecurityMechanismSelector sms = new SecurityMechanismSelector();
        ServerConnectionContext scc = null;
        if (c != null) {
            s = c.getSocket();
            if(_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE,"RECEIVED request on connection: " + c);
                _logger.log(Level.FINE,"Socket =" + s);
            }
            scc = new ServerConnectionContext(s);
        } else {
            scc = new ServerConnectionContext();
        }
        sms.setServerConnectionContext(scc);
    }

    public int compareTo(Object o)
    {
	int otherOrder = -1;
	if( o instanceof ServerConnectionInterceptor) {
            otherOrder = ((ServerConnectionInterceptor)o).order;
	}
        if (order < otherOrder) {
            return -1;
        } else if (order == otherOrder) {
            return 0;
        }
        return 1;
    }

    public void destroy() {}

    public void receive_request(ServerRequestInfo sri)    
    {
        Socket s = null;
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        // callFlowAgent should never be null.
	// If the else block is executed, its a bug.
	// more investigation needed
	if (callFlowAgent != null) {
	    boolean callFlowEnabled = callFlowAgent.isEnabled();
	    if (callFlowEnabled){
	        // Only do callflow RequestStart,
	        // If it is a ejb call and not a is_a call. For everything else
	        // do a startTime for OTHER Container
	        if (isEjbCall(sri)){
		    try {
		        try{
			    Connection c = ((RequestInfoExt)sri).connection();
			    if (c != null) {
			        s = c.getSocket();
			    }
			} finally {
			    String callerIPAddress = null;
			    if (s != null) {
                                callerIPAddress = s.getInetAddress().getHostAddress();
			    }
			    callFlowAgent.requestStart(RequestType.REMOTE_EJB);
			    callFlowAgent.addRequestInfo(
							 RequestInfo.CALLER_IP_ADDRESS, callerIPAddress);
			}
		    } catch (Exception ex){
		        _logger.log( Level.WARNING,
				     "Callflow Agent's requestStart exception" + ex);
		    }
		} else {
		    try {
		        callFlowAgent.startTime(ContainerTypeOrApplicationType.ORB_CONTAINER);
		    } catch (Exception ex){
		        _logger.log( Level.WARNING,
				     "Callflow Agent's starttime exception" + ex);
		    }
		}
	    }
	} else {
	     _logger.log( Level.FINE, "CallFlow Agent not initialized. ");
	}	
    }
    public void send_reply(ServerRequestInfo sri)
    {
        try {
            checkTransaction(sri);
        } finally {
            if (isEjbCall(sri)) {
                Switch.getSwitch().getTransactionManager().cleanTxnTimeout();
            }
            Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
	    // callFlowAgent should never be null.
	    // If the else block is executed, its a bug.
	    // more investigation needed
            if (callFlowAgent != null) {
	        boolean callFlowEnabled = callFlowAgent.isEnabled();
		if(callFlowEnabled){
		    if (isEjbCall(sri)){
		        try {
			    callFlowAgent.requestEnd();
			} catch (Exception ex) {
			    _logger.log(
				      Level.WARNING,
				      "Callflow Agent's requestEnd method exception" + ex);
			}
		    } else {
		        try {
			    callFlowAgent.endTime();
			} catch (Exception ex) {
			    _logger.log(
					Level.WARNING,
					"Callflow Agent's endtime method exception" + ex);
			}
		    }
		}	    
	    } else {
	        _logger.log( Level.FINE, "CallFlow Agent not initialized. ");
	    }
	}
    }

    public void send_exception(ServerRequestInfo sri)
    {
        try {
            checkTransaction(sri);
        } finally {
            if (isEjbCall(sri)) {
                Switch.getSwitch().getTransactionManager().cleanTxnTimeout();
            }
            Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
	    // callFlowAgent should never be null.
	    // If the else block is executed, its a bug.
	    // more investigation needed
             if (callFlowAgent != null) {	       
	         boolean callFlowEnabled = callFlowAgent.isEnabled();
		 if(callFlowEnabled){
		     if (isEjbCall(sri)){
		         try {
			     callFlowAgent.requestEnd();
			 } catch (Exception ex) {
			     _logger.log(
				       Level.WARNING,
				       "Callflow Agent's requestEnd method exception" + ex);
			 }
		     } else {
		         try {
			     callFlowAgent.endTime();
			 } catch (Exception ex) {
			     _logger.log(
					 Level.WARNING,
					 "Callflow Agent's endtime method exception" + ex);
			 }
		     }
		 }
	     } else {
	         _logger.log( Level.FINE, "CallFlow Agent not initialized. ");
	     }	
	}
    }

    public void send_other(ServerRequestInfo sri)
    {
        try {
            checkTransaction(sri);
        } finally {
            if (isEjbCall(sri)) {
                Switch.getSwitch().getTransactionManager().cleanTxnTimeout();
            }
            Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
	    // callFlowAgent should never be null.
	    // If the else block is executed, its a bug.
	    // more investigation needed
	    if (callFlowAgent != null) {
	        boolean callFlowEnabled = callFlowAgent.isEnabled();
		if(callFlowEnabled){
		    if (isEjbCall(sri)) {
		        try {
			    callFlowAgent.requestEnd();
			} catch (Exception ex) {
			    _logger.log(
					Level.WARNING,
					"Callflow Agent's requestEnd method exception" + ex);
			}
		    } else {
		        try {
			    callFlowAgent.endTime();
			} catch (Exception ex) {
			    _logger.log(
					Level.WARNING,
					"Callflow Agent's endtime method exception" + ex);
			}
		    }
		}
            } else {
	        _logger.log( Level.FINE, "CallFlow Agent not initialized. ");
	    }	    
        }
    }

    private void checkTransaction(ServerRequestInfo sri) {
	/**
	ObjectImpl target = (ObjectImpl)sri.effective_target();
        if ( !target._is_local() ) {
	    J2EETransactionManager tm = 
				    Switch.getSwitch().getTransactionManager();
	    if ( tm != null )
		tm.checkTransactionExport();
	}
	**/
	J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
	if ( tm != null )
	    tm.checkTransactionImport();
    }
    /**
     * Returns true, if the incoming call is a EJB method call. 
     * This checks for is_a calls and ignores those calls. In callflow analysis
     * when a component looks up another component, this lookup should be 
     * considered part of the same call coming in. 
     * Since a lookup triggers the iiop codebase, it will fire a new request start.
     * With this check, we consider the calls that are only new incoming ejb
     * method calls as new request starts.
     */
    private boolean isEjbCall (ServerRequestInfo sri) {
        if (ORBManager.isEjbAdapterName(sri.adapter_name()) &&
                (!ORBManager.isIsACall(sri.operation()))) {
            return true;
        } else 
            return false;
    }
}
