/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.iiop;

import java.util.logging.*;
import java.util.Properties;
import java.io.IOException;

import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.INTERNAL;
import org.omg.IOP.Codec;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;

import org.omg.CosTransactions.*;
import org.omg.CosTSInteroperation.TAG_OTS_POLICY;
import org.omg.CosTSInteroperation.TAG_INV_POLICY;

import com.sun.logging.*;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.iiop.ASORBUtilities;


public class TxSecIORInterceptor extends org.omg.CORBA.LocalObject
                    implements org.omg.PortableInterceptor.IORInterceptor {
    

    private static Logger _logger=null;

    static {
	_logger=LogDomains.getLogger(LogDomains.CORBA_LOGGER);
    }

    private Codec codec;
    
    
    public TxSecIORInterceptor(Codec c) {
        codec = c;
    }
    
    public void destroy() {
    }
    
    public String name() {
        return "TxSecIORInterceptor";
    }
    
    // Note: this is called for all remote refs created from this ORB,
    // including EJBs and COSNaming objects.
    public void establish_components(IORInfo iorInfo) {
        try {
	    _logger.log(Level.FINE, 
			"TxSecIORInterceptor.establish_components->:");

	    // Add OTS tagged components. These are always the same for all EJBs
	    OTSPolicy otsPolicy = null;
	    try {
		otsPolicy = (OTSPolicy)iorInfo.get_effective_policy(
				   POARemoteReferenceFactory.OTS_POLICY_TYPE);
	    } catch ( INV_POLICY ex ) {
		_logger.log(Level.FINE, 
			    "TxSecIORInterceptor.establish_components: OTSPolicy not present");
	    }
	    if ( otsPolicy != null ) {
		addOTSComponents(iorInfo);
	    }

	    // Find the CSIv2 policy in effect for this IOR kind
	    CSIv2Policy csiv2Policy = null;
	    try {
		csiv2Policy = (CSIv2Policy)iorInfo.get_effective_policy(
				   POARemoteReferenceFactory.CSIv2_POLICY_TYPE);
		// REVISIT - this did not log an exception when missing.
	    } catch ( INV_POLICY ex ) {
		_logger.log(Level.FINE, 
			    "TxSecIORInterceptor.establish_components: CSIv2Policy not present");
	    }

	    // Add CSIv2 tagged component for this EJB type.
            if(_logger.isLoggable(Level.FINE)) {
		_logger.log(Level.FINE, 
			    "TxSecIORInterceptor.establish_components: CSIv2Policy: " + csiv2Policy);
	    }
	    addCSIv2Components(iorInfo, csiv2Policy);

        } catch (Exception e) {
            _logger.log(Level.WARNING,"Exception in establish_components", e);
        } finally {
	    _logger.log(Level.FINE, 
			"TxSecIORInterceptor.establish_components<-:");
	}
    }

    private void addOTSComponents(IORInfo iorInfo)
    {       
        short invPolicyValue = SHARED.value;
        short otsPolicyValue = ADAPTS.value;            
        
        Any otsAny = ORB.init().create_any();
        Any invAny = ORB.init().create_any();
        
        otsAny.insert_short(otsPolicyValue);
        invAny.insert_short(invPolicyValue);
        
        byte[] otsCompValue = null;
        byte[] invCompValue = null;                 
        try {
            otsCompValue = codec.encode_value(otsAny);
            invCompValue = codec.encode_value(invAny);
        } catch (org.omg.IOP.CodecPackage.InvalidTypeForEncoding e) {
            throw new INTERNAL("InvalidTypeForEncoding "+e.getMessage());
        }
    
        TaggedComponent otsComp = new TaggedComponent(TAG_OTS_POLICY.value,
                                                      otsCompValue);
	iorInfo.add_ior_component(otsComp);

        TaggedComponent invComp = new TaggedComponent(TAG_INV_POLICY.value,
                                                      invCompValue);
	iorInfo.add_ior_component(invComp);
    }

    private void addCSIv2Components(IORInfo iorInfo, CSIv2Policy csiv2Policy)
    {
      try {
	if(_logger.isLoggable(Level.FINE)) {
	    _logger.log(Level.FINE, 
			".addCSIv2Components->: "
			+ " " + iorInfo + " " + csiv2Policy);
	}
        if (ASORBUtilities.isGMSAvailableAndClusterHeartbeatEnabled()) {
            return;
        }

	EjbDescriptor ejbDesc = null;

	if ( csiv2Policy != null ) {
	    ejbDesc = csiv2Policy.getEjbDescriptor();
	}

	if(_logger.isLoggable(Level.FINE)) {
	    _logger.log(Level.FINE, 
			".addCSIv2Components: ejbDesc: " + ejbDesc);
	}

	ORB orb = ORBManager.getORB();

	int sslMutualAuthPort = -1;
	try {
	    sslMutualAuthPort = ((com.sun.corba.ee.spi.legacy.interceptor.IORInfoExt)iorInfo).
								getServerPort("SSL_MUTUALAUTH");
	} catch (com.sun.corba.ee.spi.legacy.interceptor.UnknownType ute) {
            _logger.log(Level.FINE,"UnknownType exception", ute);
	}

	if(_logger.isLoggable(Level.FINE)) {
	    _logger.log(Level.FINE, 
			".addCSIv2Components: sslMutualAuthPort: " 
			+ sslMutualAuthPort);
	}

	CSIV2TaggedComponentInfo ctc = new CSIV2TaggedComponentInfo(orb);
	ctc.setSSLMutualAuthPort(sslMutualAuthPort);

	// Create CSIv2 tagged component
	int sslport = -1;
	try {
	    sslport = ((com.sun.corba.ee.spi.legacy.interceptor.IORInfoExt)iorInfo).
								getServerPort("SSL");
	} catch (com.sun.corba.ee.spi.legacy.interceptor.UnknownType ute) {
            _logger.log(Level.FINE,"UnknownType exception", ute);
	}

	if(_logger.isLoggable(Level.FINE)) {
	    _logger.log(Level.FINE, 
			".addCSIv2Components: sslport: " 
			+ sslport);
	}

	TaggedComponent csiv2Comp = null;
	if ( ejbDesc != null ) {
	    csiv2Comp = ctc.createSecurityTaggedComponent(sslport, ejbDesc);
	}
	else { 
	    // this is not an EJB object, must be a non-EJB CORBA object
	    csiv2Comp = ctc.createSecurityTaggedComponent(sslport);
	}

	iorInfo.add_ior_component(csiv2Comp);

      } finally {
	  if(_logger.isLoggable(Level.FINE)) {
	      _logger.log(Level.FINE,
			  ".addCSIv2Components<-: "
			  + " " + iorInfo + " " + csiv2Policy);
	  }
      }
    }
}

// End of file.
