/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

/**
 * A Configuration object stores all the properties that are needed
 * by various components within the EJB server.    
 * @author Harish Prabandham
 */
public interface Configuration extends java.rmi.Remote {
    /**
     * This method gets a property value associated with the given key.
     * @param The key for the property.
     * @return A property value corresponding to the key
     */
    public String getProperty(String key) throws java.rmi.RemoteException;
    
    /**
     * This method associates a property value with the given key.
     * @param The key for the property.
     * @param The value for the property.
     */
    public void setProperty(String key, String value) 
	throws java.rmi.RemoteException;
    
    /**
     * This method removes value corresponding to the key.
     * @param The key for the property.     
     */
    public void removeProperty(String key) throws java.rmi.RemoteException;
    
    /**
     * This method gets an Object associated with the given key.
     * @param The key for the property.     
     * @return An Object corresponding to the key
     */
    public Object getObject(String key) throws java.rmi.RemoteException;
    
    /**
     * This method associates an Object with the given key. The Object
     * must implement Serializable interface.
     * @param The key for the property.     
     * @param The object to be stored.
     */
    public void setObject(String key, Object obj) 
	throws java.rmi.RemoteException;
    
    /**
     * This method removes an Object with the given key.
     * @param The key for the property.     
     */
    public void removeObject(String key) throws java.rmi.RemoteException;
    
    
    /**
     * This method returns all the keys for the given index. The index is
     * name before the first . for a given property. For example. 
     * If there's a property called http.server.port. The index name for 
     * this property is http
     * @param The index name of the repository, 
     */
    public String[] getKeys(String index) throws java.rmi.RemoteException;
}

