/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.util.Hashtable;

/**
 * Intermediate representation of J2EE resource information.
 *
 * @author Kenneth Saks 
 */
public class RawResourceInfo {

    private String resourceType_;
    private int index_;
    private Hashtable attributes_;
    private Hashtable properties_;

    public RawResourceInfo(String resourceType, int index) {
        resourceType_ = resourceType;
        index_ = index;
        attributes_ = new Hashtable();
        properties_ = new Hashtable();
    }

    public String getResourceType() {
        return resourceType_;
    }
    
    public int getIndex() {
        return index_;
    }

    public Hashtable getAttributes() {
        return attributes_;
    }

    public Hashtable getProperties() {
        return properties_;
    }

    public int hashCode() {
        return resourceType_.hashCode();
    }

    public boolean equals(Object o) {
        if( o instanceof RawResourceInfo ) {
            RawResourceInfo other = (RawResourceInfo) o;
            return other.resourceType_.equals(resourceType_) &&
                (other.index_ == index_);
        } else {
            return false;
        }
    }

    public String toString() {
        return "< Raw resource info : " + getResourceType() + " , " +
            getIndex() + " , " + getAttributes() + " , " + 
            getProperties() + " >";
    }
}
