/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.util.Set;
import java.util.Properties;

public interface ResourceAdmin {

    // Messaging style
    int QUEUE = 1;
    int TOPIC = 2;

    /**
     * Add and configure a connection factory
     * @param AppName Name of application (can be null if the adapter
     * @param connectorName Name of resource adapter
     * is deployed standalone)
     * @param jndiName JNDI name of Connection Factory
     * @param xaRecoveryUser username for xa recovery purpose (optional)
     * @param xaRecoveryPassword password for xa recovery purpose (optional)
     * @param props properties to be set on the connection factory
     */
     ConnectorResource addConnectionFactory(String appName,
                                            String connectorName,
                                            String jndiName,
                                            String xaRecoveryUser,
                                            String xaRecoveryPassword,
                                            Properties props) 
        throws J2EEResourceException;

    void addResource(J2EEResource resource) 
        throws J2EEResourceException;

    Set  getResources(int resourceType) 
        throws J2EEResourceException;

    void removeResource(String name, int resourceType)
        throws J2EEResourceException;

    void removeAllResources(int resourceType)
        throws J2EEResourceException;

}
