/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.security;

import java.util.*;
import java.io.*;
import java.util.logging.*;
import javax.naming.Context;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.security.auth.RemoteObject;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.security.RealmConfig;
import com.sun.logging.*;


/**
 * This class has methods to startup and access the Realm and register
 * it within the current Name Service.
 * @see IRealmManager the remote interface to access the realm
 * @author Harpreet Singh
 */

public class RealmManager extends RemoteObject implements IRealmManager{

    private static Logger _logger=null;
    static {
        _logger=LogDomains.getLogger(LogDomains.SECURITY_LOGGER);
    }

    // Name of the Realm Manager Service in the Name Service.
    public static String REALM_MANAGER_NAME = "Realm_Manager"; 

    
    /**
     * Creates a new instance of the Realm Manager.
     * This call expects that an initialized ORB has been set in the
     * ORBManager
     * @see com.sun.enterprise.util.ORBManager
     */
    public RealmManager() {
	super();
    }

    
    /**
     * Initializes the Realm Manager Server & binds the name in the 
     * Name Service.
     * @exception A javax.naming.NamingException is thrown if unable 
     * to register the Authentication Server. 
     */
    public void init()
	throws javax.naming.NamingException, java.rmi.RemoteException {

            RealmConfig.createRealms();
    }

    
    /**
     * Starts the Authentication Server & waits forever for invocations.
     */
    public void start() throws java.lang.InterruptedException {
	// wait for object invocation
	Object sync = new Object();
	synchronized (sync) { 
	    sync.wait(); 
	}
    }

    
    public void refreshRealms(String realmName) 
	throws java.rmi.RemoteException{
	    try{
		Realm r = Realm.getInstance(realmName);
		r.refresh();
	    }catch (Exception e){
		throw new java.rmi.RemoteException(e.toString());
	    }
    }

    
    /**
     *
     * Starts up a standalone  Realm Manager. It uses the command
     * line arguments to initialize the ORB.
     *
     */
    public static void main(String[] args) {
  	try {
	    Utility.checkJVMVersion();
	    // Initialize the ORB if not already started.
	    ORBManager.getORB() ;

	    Switch theSwitch = Switch.getSwitch();
	    NamingManager nm = new NamingManagerImpl();
	    theSwitch.setNamingManager(nm);
	    
	    RealmManager mgr = new RealmManager();
	    mgr.init(); // Initialize the Authentication Service ...
	    mgr.start(); // Start the Server.
        } catch (Exception ex) {
 	    _logger.log(Level.SEVERE,
                        "java_security.realm_manager_exception",ex);
	}
    }

    
}



