/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server;

import com.sun.enterprise.config.serverbeans.*;
import com.sun.enterprise.config.*;
import com.sun.enterprise.config.ConfigException;
import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.logging.LogDomains;
import com.sun.enterprise.admin.event.ResourceDeployEvent;

/**
  *
  * @author    Aditya Gore
  * @version
 */

public class JdbcResourcesLoader  extends ResourcesLoader{

    static Logger _logger = LogDomains.getLogger(LogDomains.CORE_LOGGER);
    /** context of the server instance runtime */


    public JdbcResourcesLoader(ServerContext sc) throws ConfigException{
        super(sc); 
    }



    public void load() {
        ConfigBean[][] cb = null;
        try {
            cb = resourceUtil.getJdbcResources();
            if(cb != null)
                load(cb);
        }
        catch(ConfigException ce) {
            _logger.log(Level.SEVERE,"core.connectorresource_read_error" );
            _logger.log(Level.SEVERE,"" ,ce);
        }
    }

}
