/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server;

import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.jms.*;
import com.sun.enterprise.config.serverbeans.*;
import com.sun.enterprise.config.*;
import com.sun.enterprise.connectors.*;
import com.sun.enterprise.connectors.system.*;



/**
 * Listener class to handle jms-host element events.
 *
 * @author: Binod
 */
public class JmsHostEventListener implements 
             com.sun.enterprise.admin.event.jms.JmsHostEventListener {

    private ConnectorRegistry registry = ConnectorRegistry.getInstance();

    /**
     * Handles jms-host element removal.
     * It is called whenever a JmsHostEvent is received.
     *
     * @param event                        Event to be processed.
     *
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void handleDelete(JmsHostEvent event)
             throws AdminEventListenerException {
        reloadRA(event);
        //getAdapter().deleteJmsHost(host);
    }

    /**
     * Handles jms-host element modification 
     * (attributes/properties values changed).
     * It is called whenever a JmsHostEvent is received.
     *
     * @param event                        Event to be processed.
     *
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void handleUpdate(JmsHostEvent event)
             throws AdminEventListenerException {
        reloadRA(event);
        //getAdapter().updateJmsHost(host);
    }

    /**
     * Handles element additions.
     * It is called whenever a JmsHostEvent is received.
     *
     * @param event                        Event to be processed.
     *
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void handleCreate(JmsHostEvent event)
             throws AdminEventListenerException {
         reloadRA(event);
        //getAdapter().addJmsHost(host);
    }

    private void reloadRA(JmsHostEvent event) throws AdminEventListenerException {
        try {
            JmsService service = (JmsService) getJmsService(event);
            ActiveJmsResourceAdapter aja = getAdapter();
            if (aja != null) { 
               getAdapter().reloadRA(service);
            }
        } catch (ConnectorRuntimeException cre) {
            AdminEventListenerException ale =
                new AdminEventListenerException(cre.getMessage());
            ale.initCause(cre);
            throw ale;
        } catch (ConfigException ce) {
            AdminEventListenerException ale =
                new AdminEventListenerException(ce.getMessage());
            ale.initCause(ce);
            throw ale;
        }
    }

    private ActiveJmsResourceAdapter getAdapter(){
        return (ActiveJmsResourceAdapter)
        registry.getActiveResourceAdapter(ConnectorRuntime.DEFAULT_JMS_ADAPTER);
    }

    private JmsService getJmsService(JmsHostEvent event) throws ConfigException{
        ConfigContext context = event.getConfigContext();
        return ServerBeansFactory.getJmsServiceBean(context);
    }
}
