/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server.logging;

import java.util.logging.ErrorManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

import com.sun.enterprise.admin.event.LogLevelChangeEventListener;
import com.sun.enterprise.admin.event.LogLevelChangeEvent;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigUpdate;      

public class LogLevelChangeEventListenerImpl 
    implements LogLevelChangeEventListener
{
    public void logLevelChanged(LogLevelChangeEvent event)
        throws AdminEventListenerException 
    {
        try {
            if( event.isPropertyChanged() ) {
                ConfigContext newConfig = event.getConfigContext();                
                Iterator iter = event.getConfigChangeList().iterator();
                while (iter.hasNext() )  {
                    Object change= iter.next();
                    if (change instanceof ConfigAdd || change instanceof ConfigUpdate) {
                        String xpath = ((ConfigChange)change).getXPath();
                        if( xpath != null){
                            ConfigBean item = newConfig.exactLookup(xpath); 
                            if (item instanceof ElementProperty) {
                                ElementProperty elementProperty = (ElementProperty)item;
                                String loggerName  = elementProperty.getName();
                                String logLevel    = elementProperty.getValue();
                                boolean logExists = LogMBean.getInstance().findLogger(loggerName);
                                if (!logExists) {
                                    Logger.getLogger(loggerName);  //if the logger doesn't exist, create it.
				}        
                                LogMBean.getInstance().setLogLevel( loggerName, logLevel );
                            }
                        }
                    }
                }
            } else {
                // This is not a property change event, so it must be a 
                // module log level change.
                LogMBean.getInstance().setLogLevelForModule(
                    event.getModuleName(), event.getNewLogLevel() );
            }
        } catch( Exception e ) {
            new ErrorManager().error( "Error In LogLevelChanged event", e,
                ErrorManager.GENERIC_FAILURE );
        }
    }
}
