/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.server.ss.provider;

import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;

                                                                                                                             
/**
 * SelectionKey implementation for the socket wrappers of Quick startup
 * implementation. 
 * Basic reason for introducing this class is to make sure that any service
 * that does a SelectionKey.channel().accept() to accept the connections
 * are blocked until the server startup completes.
 *
 * @see ASSelector
 */
public class ASSelectionKey extends SelectionKey {

    private SelectableChannel channel = null;
    private SelectionKey key = null;

    private Selector sel = null;

    ASSelectionKey(SelectableChannel channel,
                   SelectionKey key,
                   Selector sel) {
        this.channel = channel;
        this.key = key;
        this.sel = sel;
    } 

    public SelectableChannel channel() {
        return channel;
    }

    public Selector selector() {
        return sel;
    }

    public boolean isValid() {
        return key.isValid();
    }

    public void cancel() {
        key.cancel();
    }

    public int interestOps() {
        return key.interestOps();
    }

    public SelectionKey interestOps(int i) {
        return key.interestOps(i);
    }

    public int readyOps() {
        return key.readyOps();
    }

    public boolean equals(java.lang.Object obj) {
        return key.equals(obj);
    }

    public int hashCode() {
        return key.hashCode();
    }
}
