/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.transaction;

import javax.transaction.*;
import com.sun.enterprise.*;

/**
* This class is wrapper for the actual transaction manager implementation.
* JNDI lookup name "java:appserver/TransactionManager"
* see the com/sun/enterprise/naming/java/javaURLContext.java
**/

public class TransactionManagerHelper implements TransactionManager {

    public void begin() throws NotSupportedException, SystemException {
	Switch.getSwitch().getTransactionManager().begin();
    }

    
    public void commit() throws RollbackException,
	HeuristicMixedException, HeuristicRollbackException, SecurityException,
	IllegalStateException, SystemException {
	Switch.getSwitch().getTransactionManager().commit();
    }

    public int getStatus() throws SystemException {
	return Switch.getSwitch().getTransactionManager().getStatus();
    }

    public Transaction getTransaction() throws SystemException {
	return Switch.getSwitch().getTransactionManager().getTransaction();
    }

    
    public void resume(Transaction tobj)
            throws InvalidTransactionException, IllegalStateException,
            SystemException {
	Switch.getSwitch().getTransactionManager().resume(tobj);
    }

    
    public void rollback() throws IllegalStateException, SecurityException,
                            SystemException {
	Switch.getSwitch().getTransactionManager().rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
	Switch.getSwitch().getTransactionManager().setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
	Switch.getSwitch().getTransactionManager().setTransactionTimeout(seconds);
    }

    public Transaction suspend() throws SystemException {
	return Switch.getSwitch().getTransactionManager().suspend();
    }

    public static TransactionManager getTransactionManager() {
	return tmHelper;
    }

    private static TransactionManagerHelper tmHelper = new TransactionManagerHelper();

}
