/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * AppclientWSSCallbackHandler.java
 *
 * Created on September 14, 2004, 12:20 PM
 */

package com.sun.enterprise.webservice;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import java.io.IOException;
import java.util.logging.*;
import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.security.wss.*;
import com.sun.enterprise.security.jauth.callback.*;



/**
 * Appclient side Callback Handler for WSS.
 * @author  Harpreet Singh
 */
public final class AppclientWSSCallbackHandler extends WSSCallbackHandler {
    private static final String LOGIN_NAME = "j2eelogin.name";
    private static final String LOGIN_PASSWORD = "j2eelogin.password";
    private static WSSCallbackHandler INSTANCE = null;
    /** Creates a new instance of AppclientWSSCallbackHandler */
    private AppclientWSSCallbackHandler() {
    }
    // cannot use getInstance as super class has a method with that name
    /**
     * returns a singleton instance of this class.
     */    
    static WSSCallbackHandler newInstance() {
        if(INSTANCE == null){
            INSTANCE = new AppclientWSSCallbackHandler();
        }
        return INSTANCE;
    }

    public void handle(Callback[] callbacks) 
        throws IOException, UnsupportedCallbackException 
    {
        if(callbacks == null){
            return;
        }
        // this variable is set to true if we have used the older jaas
        // mechanisms to process the callbacks - and we will not need 
        // to process further as the inside loop, just takes care
        // of processing all callbacks
        boolean processedSomeAppclientCallbacks = false;
        for (int i=0; i<callbacks.length; i++){
            if(!isSupportedCallback(callbacks[i])){
                _logger.log(Level.FINE, "wss-container-auth: UnsupportedCallback : "+
                callbacks[i].getClass().getName());
                throw new UnsupportedCallbackException(callbacks[i]);
            }
            if(!processedSomeAppclientCallbacks){
                if((callbacks[i] instanceof NameCallback) ||
                (callbacks[i] instanceof PasswordCallback) ||
                (callbacks[i] instanceof ChoiceCallback)) {

                    String loginName = System.getProperty(LOGIN_NAME);
                    CallbackHandler callbackHandler = AppContainer.getCallbackHandler();
                    if(loginName != null){// username/password set already
                        String password = System.getProperty(LOGIN_PASSWORD);
                        for(int j = 0; j < callbacks.length; j++){
                            if(callbacks[j] instanceof NameCallback){
                                NameCallback nc = (NameCallback)callbacks[j];
                                nc.setName(loginName);
                            } else if (callbacks[j] instanceof PasswordCallback){
                                PasswordCallback pc = (PasswordCallback)callbacks[j];
                                if(password != null)
                                    pc.setPassword(password.toCharArray());
                                else{
                                    callbackHandler.handle(callbacks);
                                }
                            }
                        }
                    } else{
                        // once this is called all callbacks will be handled by
                        // callbackHandler and then we dont have to check for
                        // NameCallback PasswordCallback and ChoiceCallback
                        // again.
                        // Let control flow to the callback processors
                        callbackHandler.handle(callbacks);
                    }
                    processedSomeAppclientCallbacks = true;
                    break;
                }
            }
            processCallback(callbacks[i]);
        }
    }

    boolean isSupportedCallback(Callback callback) 
    {
       boolean supported = false;
        if (callback instanceof NameCallback) {
            supported = true;
        } else if (callback instanceof PasswordCallback) {
            supported = true;
        } else if (callback instanceof ChoiceCallback) {
            supported = true;
        } else if (callback instanceof CertStoreCallback) {
            supported = true;
        } else if (callback instanceof PasswordValidationCallback) {
            supported = true;
        } else if (callback instanceof SecretKeyCallback) {
            supported = true;
        } else if (callback instanceof PrivateKeyCallback) {
            supported = true;
        } else if (callback instanceof TrustStoreCallback) {
            supported = true;
        } else {
            supported = false;
        }
        return supported;
    }
    
}
