/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.webservice;

import java.lang.reflect.Method;

import java.rmi.UnmarshalException;

import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;


import com.sun.enterprise.Switch;
import com.sun.ejb.Container;
import com.sun.ejb.Invocation;
import com.sun.enterprise.InvocationManager;

import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

/**
 * This handler is inserted last in the handler chain for an
 * ejb web service endpoint.  It ensures that the application handlers
 * did not change anything in the soap message that would change the
 * dispatch method.
 *
 * @author Kenneth Saks
 */
public class EjbContainerPostHandler extends GenericHandler {

    private static Logger logger = 
        LogDomains.getLogger(LogDomains.EJB_LOGGER);    
    private WsUtil wsUtil = new WsUtil();

    public EjbContainerPostHandler() {}

    public QName[] getHeaders() {
        return new QName[0];
    }

    public boolean handleRequest(MessageContext context) {
        Invocation inv = null;
        boolean continueProcessing = true;

        try {
            Switch theSwitch = Switch.getSwitch();
            InvocationManager invManager = theSwitch.getInvocationManager();
            inv = (Invocation) invManager.getCurrentInvocation();
            Container container = (Container) inv.container;

            Method webServiceMethodInPreHandler = inv.getWebServiceMethod();

            if( webServiceMethodInPreHandler != null ) {
                // Now that application handlers have run, do another method
                // lookup and compare the results with the original one.  This
                // ensures that the application handlers have not changed
                // the message context in any way that would impact which
                // method is invoked.
                Method postHandlerMethod = 
                    wsUtil.getInvMethod(inv.getWebServiceTie(), context);
                if( !webServiceMethodInPreHandler.equals(postHandlerMethod) ) {
                    inv.exception = new UnmarshalException
                        ("Original method " + webServiceMethodInPreHandler + 
                         " does not match post-handler method " + 
                         postHandlerMethod);
                }
            }
        } catch(Exception e) {
            String errorMsg = "Exception while getting method for " +
                ((inv != null ) ?
                 ((Container) inv.container).getEjbDescriptor().getName() : "");
            inv.exception = new UnmarshalException(errorMsg);
            inv.exception.initCause(e);
        }
        
        if( inv.exception != null ) {
            logger.log(Level.WARNING, "postEjbHandlerError", inv.exception);
            wsUtil.throwSOAPFaultException(inv.exception.getMessage(),
                                           context);
        }

        return true;
    }

}
