/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.webservice;

import java.util.Iterator;

import java.rmi.RemoteException;
import java.rmi.UnmarshalException;

import javax.xml.namespace.QName;

import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;

import com.sun.enterprise.Switch;
import com.sun.ejb.Container;
import com.sun.ejb.Invocation;
import com.sun.enterprise.InvocationManager;

import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

/**
 * This handler is inserted first in the handler chain for an
 * ejb web service endpoint.  It performs security authorization 
 * before any of the application handlers are invoked, as required
 * by JSR 109.
 *
 * @author Kenneth Saks
 */
public class EjbContainerPreHandler extends GenericHandler {

    private static Logger logger = LogDomains.getLogger(LogDomains.EJB_LOGGER);    
    private WsUtil wsUtil = new WsUtil();

    public EjbContainerPreHandler() {}

    public QName[] getHeaders() {
        return new QName[0];
    }

    public boolean handleRequest(MessageContext context) {
        Invocation inv = null;
        Container container = null;

        try {

            Switch theSwitch = Switch.getSwitch();
            InvocationManager invManager = theSwitch.getInvocationManager();
            inv = (Invocation) invManager.getCurrentInvocation();
            container = (Container) inv.container;

            inv.method = wsUtil.getInvMethod(inv.getWebServiceTie(), context);

            // Result can be null for some error cases.  This will be
            // handled by jaxrpc runtime so we don't treat it as an exception.
            if( inv.method != null ) {
                inv.setWebServiceMethod(inv.method);
               
                if ( !container.authorize(inv) ) {
                    inv.exception = new Exception
                        ("Client not authorized for invocation of " 
                         + inv.method);
                }
            } else {
                inv.setWebServiceMethod(null);
            }
        } catch(Exception e) {
            String errorMsg = "Error unmarshalling method " + 
                ( (container != null ) ?
                  "for ejb " + container.getEjbDescriptor().getName() : 
                  "" );
            inv.exception = new UnmarshalException(errorMsg);
            inv.exception.initCause(e);
        }
        
        if( inv.exception != null ) {
            logger.log(Level.WARNING, "preEjbHandlerError", inv.exception);
            wsUtil.throwSOAPFaultException(inv.exception.getMessage(),
                                           context);
        }

        return true;
    }

}
