/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.webservice;

/**
 * This factory is required to avoid ClassLoader issues. ServiceEngine
 * creates the instance of this factory during it's initialization.
 *
 * @author Manisha Umbarje
 */
public class ServiceEngineRtObjectFactory {
    
    //private static ServiceEngineRtObjectFactory seRtObjectFactory = null;
    private ServiceEngineFacade facade;
    private static ServiceEngineRtObjectFactory factory = null;
    
    private  ServiceEngineRtObjectFactory() {
    }
    
    public static ServiceEngineRtObjectFactory getInstance() {
        if (factory == null)
            factory = new ServiceEngineRtObjectFactory();
        return factory;
    }
    
    /**
     * This method is used by the ServiceEngine to set the Facade
     * for usage from CommonClassLoader . Implementation of ServiceEngineFacade
     * is provided by the ServiceEngine
     */
    public void setFacade(ServiceEngineFacade facade) {
        this.facade = facade;
    }
    
    public ServiceEngineFacade getFacade() {
        return facade;
    }
}
