/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.webservice;

import java.util.Iterator;

import java.lang.reflect.Method;

import java.rmi.RemoteException;
import java.rmi.UnmarshalException;

import javax.xml.namespace.QName;

import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;

import com.sun.enterprise.Switch;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;

import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

/**
 * This handler is inserted last in the handler chain for an
 * servlet web service endpoint.  
 *
 * @author Kenneth Saks
 */
public class ServletPostHandler extends GenericHandler {

    private static Logger logger = 
        LogDomains.getLogger(LogDomains.WEB_LOGGER);    
    private WsUtil wsUtil = new WsUtil();

    public ServletPostHandler() {}

    public QName[] getHeaders() {
        return new QName[0];
    }

    public boolean handleRequest(MessageContext context) {
        ComponentInvocation inv = null;

        try {
            Switch theSwitch = Switch.getSwitch();
            InvocationManager invManager = theSwitch.getInvocationManager();
            inv = invManager.getCurrentInvocation();

            Method webServiceMethodInPreHandler = inv.getWebServiceMethod();
            if( webServiceMethodInPreHandler != null ) {
                Method postHandlerMethod = 
                    wsUtil.getInvMethod(inv.getWebServiceTie(), context);
            
                if( !webServiceMethodInPreHandler.equals(postHandlerMethod) ) {
                    throw new UnmarshalException
                        ("Original method " + webServiceMethodInPreHandler 
                         + " does not match post-handler method " + 
                         postHandlerMethod);
                } 
            }
        } catch(Exception e) {
            logger.log(Level.WARNING, "postWebHandlerError", e);
            wsUtil.throwSOAPFaultException(e.getMessage(), context);
        }

        return true;
    }

}
