/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice;

import java.security.Principal;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.MessageContext;
import javax.servlet.http.HttpServletRequest;
import com.sun.xml.ws.spi.runtime.WebServiceContext;
import com.sun.web.security.WebPrincipal;
import com.sun.enterprise.Switch;
import com.sun.enterprise.InvocationManager;
import com.sun.ejb.containers.StatelessSessionContainer;

public class WebServiceContextImpl implements WebServiceContext  {
    
    public static ThreadLocal msgContext = new ThreadLocal();
    
    public static ThreadLocal principal = new ThreadLocal();
    
    public MessageContext getMessageContext() {
        MessageContext ctxt = (MessageContext)msgContext.get();
        return ctxt;
    }
    
    public void setMessageContext(MessageContext ctxt) {
        msgContext.set(ctxt);
    }

    public void setUserPrincipal(WebPrincipal p) {
        principal.set(p);
    }
    
    public Principal getUserPrincipal() {
        // This could be an EJB endpoint; check the threadlocal variable
        WebPrincipal p = (WebPrincipal) principal.get();
        if (p != null) {
            return p;
        }
        // This is a servlet endpoint
        MessageContext ctxt = (MessageContext)msgContext.get();
        if (ctxt != null) {
            HttpServletRequest req = (HttpServletRequest)ctxt.get(
                    MessageContext.SERVLET_REQUEST);
            if (req != null) {
                return req.getUserPrincipal();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isUserInRole(String role) {
        // This could be an EJB endpoint; check the threadlocal variable
        WebPrincipal p = (WebPrincipal) principal.get();
        if (p != null) {
            Switch sw = Switch.getSwitch();
            InvocationManager mgr = sw.getInvocationManager();
            StatelessSessionContainer cont = 
                    (StatelessSessionContainer) mgr.getCurrentInvocation().getContainerContext();
            boolean res = cont.getSecurityManager().isCallerInRole(role);
            return res;
        }
        // This is a servlet endpoint
        MessageContext ctxt = (MessageContext)msgContext.get();
        if (ctxt != null) {
            HttpServletRequest req = (HttpServletRequest)ctxt.get(
                    MessageContext.SERVLET_REQUEST);
            if (req != null) {
                return req.isUserInRole(role);
            }
        }
        throw new IllegalStateException();
    }
}
