/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice.codegen;

import java.util.Iterator;
import com.sun.ejb.codegen.EjbcContext;

/**
 * This interface defines all behaviours of any codegen implementation
 *
 * @author  Jerome Dochez
 */
public interface Codegen {
    
    /**
     * perform the codegen with the context provided
     */
    public void run(EjbcContext context) throws Exception;

    /**
     * @return the list of source files generated by this 
     * generator
     */
    public Iterator getListOfSourceFiles();
    
    /**
     * @return the list of binary files generated by this 
     * generator
     */
    public Iterator getListOfBinaryFiles();
    
}
