/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice.spi;

/** 
 * Implementation of the provider interface suited to 
 * the application server needs.
 * 
 * @author Jerome Dochez
 */

import java.util.ArrayList;
import java.util.logging.Level;

import javax.xml.ws.Endpoint;
import javax.xml.namespace.QName;

import javax.xml.ws.spi.Provider;
import javax.xml.ws.spi.ServiceDelegate;

public class ProviderImpl extends Provider {
    
    javax.xml.ws.spi.Provider delegateProvider;
    
    /*
     * default construtor use our JAX-WS implementation to delegate most of the
     * work
     */
    public ProviderImpl() {
        delegateProvider = new com.sun.xml.ws.spi.ProviderImpl();
    }
    
    @Override
    public Endpoint createEndpoint(String bindingId, Object implementor) {
        return delegateProvider.createEndpoint(bindingId, implementor);
    }

    @Override
    public javax.xml.ws.spi.ServiceDelegate createServiceDelegate(
         java.net.URL wsdlDocumentLocation,
         QName serviceName, Class serviceClass) {

         javax.xml.ws.spi.ServiceDelegate delegate = 
                 delegateProvider.createServiceDelegate(wsdlDocumentLocation, 
                    serviceName, serviceClass);
         
         return DefaultServiceDelegateFactory.getFactory().create(delegate);         
    }

    @Override
    public Endpoint createAndPublishEndpoint(String address,
                                             Object implementor) {
        return delegateProvider.createAndPublishEndpoint(address, implementor);
    }
}
        