
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.web.connector.grizzly;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
 * A rule is used to define operations, and can be executed by invoking 
 * <code>call</code> directly or using any objects that supports the
 * <code>Callable</code> interface. The rule can always be cancelled based on
 * its <code>Futore</code>.
 *
 * @author Jeanfrancois Arcand
 */
public interface Rule<E> extends Callable{

    /**
     * Attach a <code>E</code> to this rule.
     */
    public void attach(E o);
    
    
    /**
     * Return the current attachement <E>
     */
    public E attachement();
    
    
    /**
     * Cancel execution of this rule.
     */
    public void cancel();
    
    
    /**
     * Set the <code>Future</code> associated with this execution of this rule.
     */
    public void setFuture(Future future);
    
    
    /**
     * Set the interval in seconds to wait before executing this rule.
     */
    public void setExecutionTime(int time);
    
    
    /**
     * Return the time in second before this rule will be executed.
     */
    public int getExecutionTime();
}
