/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

#include <grp.h>
#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>
#include <security/pam_appl.h>

#ifndef STANDALONE
#include <jni.h>
#include "com_sun_enterprise_server_logging_SystemLogHandler.h"
#endif


/*
 * Class:     UtilForSyslog
 * Method:    logMessage
 * Signature:
 */
JNIEXPORT void JNICALL Java_com_sun_enterprise_server_logging_SystemLogHandler_logMessage
(JNIEnv *env, jobject obj, jstring fName, jstring level, jstring message) 
{

    static char *SEVERE = "SEVERE";
    static char *WARNING = "WARNING";
    static char *INFO = "INFO";
    static char *CONFIG = "CONFIG";
    static char *FINE = "FINE";
    static char *FINER = "FINER";
    static char *FINEST = "FINEST";

    const char *fileName = (*env)->GetStringUTFChars(env, fName, 0);
    const char *loggedLevel = (*env)->GetStringUTFChars(env, level, 0);
    const char *loggedMessage = (*env)->GetStringUTFChars(env, message, 0);

    if( strcmp( loggedLevel, SEVERE ) == 0 ) {
        openlog (fileName, LOG_NDELAY, LOG_DAEMON);
        syslog (LOG_ERR,  loggedMessage );
        closelog ();
    } else if( strcmp( loggedLevel, WARNING ) == 0 ) {
        openlog (fileName, LOG_NDELAY, LOG_DAEMON);
        syslog (LOG_WARNING,  loggedMessage );
        closelog ();
    } else if( strcmp( loggedLevel, INFO ) == 0 ) {
        openlog (fileName, LOG_NDELAY, LOG_DAEMON);
        syslog (LOG_INFO,  loggedMessage );
        closelog ();
    } else if( ( strcmp( loggedLevel, CONFIG ) == 0 )
             ||( strcmp( loggedLevel, FINE ) == 0 )
             ||( strcmp( loggedLevel, FINER ) == 0 )
             ||( strcmp( loggedLevel, FINEST) == 0 ) )
    {
        openlog (fileName, LOG_NDELAY, LOG_MAIL); // LOG_CONS | LOG_PID |
        syslog (LOG_DEBUG,  loggedMessage );
        closelog ();
    }
    (*env)->ReleaseStringUTFChars(env, fName, fileName);
    (*env)->ReleaseStringUTFChars(env, level, loggedLevel);
    (*env)->ReleaseStringUTFChars(env, message, loggedMessage);
}
