/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;

/** 
 * All web modules in the application have a non-blank context-root 
 */

public class AppWebContext extends ApplicationTest implements AppCheck { 


    /** 
     * All web modules in the application have a non-blank context-root
     *
     * @param descriptor the Application deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(Application descriptor) {

	Result result = getInitializedResult();

  
	if (descriptor.getWebBundleDescriptors().size() > 0) {
	    boolean oneWarning = false;
	    for (Iterator itr = descriptor.getWebBundleDescriptors().iterator(); itr.hasNext();) {
		WebBundleDescriptor wbd = (WebBundleDescriptor) itr.next();
		if (wbd.getContextRoot().equals("")) {
		    // fail test can't be blank , 
		    if (!oneWarning) {
			oneWarning =true;
		    }
		    result.addWarningDetails
			(smh.getLocalString
			 (getClass().getName() + ".warning",
			  "Warning: [ {0} ] has blank context root defined within application [ {1} ]",
			  new Object[] {wbd.getName(), descriptor.getName()}));
		} else {
		    result.addGoodDetails
			(smh.getLocalString
			 (getClass().getName() + ".passed",
			  "[ {0} ] has context root defined as [ {1} ] within application[ {2} ].",
			  new Object[] {wbd.getName(), wbd.getContextRoot(), descriptor.getName()}));
		}
	    }

	    if (oneWarning) {
		result.setStatus(Result.WARNING);
	    } else {
		result.setStatus(Result.PASSED);
	    }
	} else {
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "There are no web components in application [ {0} ]",
				  new Object[] {descriptor.getName()}));
	}
  
	return result;
    }
}
