/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;

/** 
 * All web modules in the application must have unique context-root. 
 */

public class AppWebContextUnique extends ApplicationTest implements AppCheck { 


    /** 
     * All web modules in the application must have unique context-root.
     * Applicable for j2ee 1.3 or below. For 1.4 and above xml schema takes care of this.
     * @param descriptor the Application deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(Application descriptor) {

	Result result = getInitializedResult();
        Set webs=descriptor.getWebBundleDescriptors();
        if(webs.size()<=1){
            result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "There is one or less web component in application [ {0} ]",
				  new Object[] {descriptor.getName()}));        
            return result;
        }
        Set<String> contexts=new HashSet<String>();
        Iterator itr=webs.iterator();
        boolean oneFailed=false;
	while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor) itr.next();
            String ctx=wbd.getContextRoot();
            if(!contexts.add(ctx)){
                oneFailed=true;
                result.failed(
                    (smh.getLocalString
                     (getClass().getName() + ".failed",
                      "Error: There is already a web module with context-root [ {0} ] within application [ {1} ]",
                      new Object[] {ctx, descriptor.getName()})));
            }
        }
	if(!oneFailed){
            result.passed(
                (smh.getLocalString
                 (getClass().getName() + ".passed",
                  "All the context-root values are unique within application [ {0} ]",
                  new Object[] {descriptor.getName()})));
        }
	return result;
    }
}
