/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * EARFileUsesClassPath.java
 *
 * Created on August 30, 2004, 9:15 AM
 */

package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.tools.verifier.Result;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/**
 *
 * @author  ss141213
 * An ear file should not contain Class-Path reference.
 * This as per J2EE 1.4 spec section#8.2. Contents from spec is given below...
 * A JAR format file (such as a .jar file, .war file, or .rar file)
 * can reference a .jar file by naming the referenced .jar file in a Class-Path header
 * in the referencing Jar file s Manifest file.
 */

public class EARFileUsesClassPath  extends ApplicationTest implements AppCheck {
    public Result check(Application descriptor){
        Result result = getInitializedResult();
        result.setStatus(Result.FAILED);
        try{
            Manifest manifest=getVerifierContext().getAbstractArchive().getManifest();
            String cp=null;
            if (manifest!=null)
                cp=manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if(cp==null || cp.length()==0){
                result.passed(smh.getLocalString(getClass().getName() + ".passed",
                    "Manifest file of this EAR file does not contain any Class-Path entry."));
            }else{
                result.failed(smh.getLocalString(getClass().getName() + ".failed",
                    "Manifest file of this EAR file contains [ {0} ] as the Class-Path entry.",
                    new Object[]{cp}));
            }
        }catch(IOException e){
            result.addErrorDetails(e.toString());
        }
        return result;
    }
}
