/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;

/** 
 * The ejb element specifies the URI of a ejb-jar, relative to
 *  the top level of the application package.
 *
 */

public class EjbURI extends ApplicationTest implements AppCheck { 


    /** The ejb element specifies the URI of a ejb-jar, relative to
     *  the top level of the application package.
     *
     * @param descriptor the Application deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(Application descriptor) {

	Result result = getInitializedResult();

  
	if (descriptor.getEjbBundleDescriptors().size() > 0) {
	    boolean oneFailed = false;
	    for (Iterator itr = descriptor.getEjbBundleDescriptors().iterator(); itr.hasNext();) {
		EjbBundleDescriptor ejbd = (EjbBundleDescriptor) itr.next();
    

		// not sure what we can do to test this string?
		if (ejbd.getModuleDescriptor().getArchiveUri().endsWith(".jar")) {
		    result.passed
			(smh.getLocalString
			 (getClass().getName() + ".passed",
			  "[ {0} ] specifies the URI [ {1} ] of an ejb-jar, relative to the top level of the application package [ {2} ].",
			  new Object[] {ejbd.getName(), ejbd.getModuleDescriptor().getArchiveUri(), descriptor.getName()}));
		} else {
		    if (!oneFailed) {
			oneFailed =true;
		    }
		    result.addErrorDetails
			(smh.getLocalString
			 (getClass().getName() + ".failed",
			  "Error: [ {0} ] does not specify the URI [ {1} ] of an ejb-jar, relative to the top level of the application package [ {2} ], or does not end with \".jar\"",
			  new Object[] {ejbd.getName(), ejbd.getModuleDescriptor().getArchiveUri(), descriptor.getName()}));
		}
	    }
	    if (oneFailed) {
		result.setStatus(Result.FAILED);
	    } else {
		result.setStatus(Result.PASSED);
	    }
	} else {
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "There are no ejb components in application [ {0} ]",
				  new Object[] {descriptor.getName()}));
	}

	return result;
    }
}
