/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;

import java.util.Set;
import java.util.HashSet;
import java.lang.reflect.Method;

/**
 * Lifecycle callback interceptor methods must not throw application exceptions. 
 * 
 * Any exception other than derived from java.lang.RuntimeException or 
 * java.rmi.RemoteException is an application exception.
 * 
 * @author Vikas Awasthi
 */
public class CallbackMethodException extends EjbTest {

    public Result check(EjbDescriptor descriptor) {
        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        ClassLoader cl = getVerifierContext().getClassLoader();

        Set<LifecycleCallbackDescriptor> callbackDescs = 
                                        new HashSet<LifecycleCallbackDescriptor>();
        
        for (EjbInterceptor interceptor : descriptor.getInterceptorClasses()) {
            callbackDescs.addAll(interceptor.getPostConstructDescriptors());
            callbackDescs.addAll(interceptor.getPreDestroyDescriptors());
            callbackDescs.addAll(interceptor.getCallbackDescriptors(
                        LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE));
            callbackDescs.addAll(interceptor.getCallbackDescriptors(
                        LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE));
        }

        if(descriptor.hasPostConstructMethod())
            callbackDescs.addAll(descriptor.getPostConstructDescriptors());
        if(descriptor.hasPreDestroyMethod())
            callbackDescs.addAll(descriptor.getPreDestroyDescriptors());
        
        // session descriptor has two extra interceptor methods.
        if(descriptor instanceof EjbSessionDescriptor) {
            EjbSessionDescriptor ejbSessionDescriptor = ((EjbSessionDescriptor)descriptor);
            if(ejbSessionDescriptor.hasPostActivateMethod())
                callbackDescs.addAll(ejbSessionDescriptor.getPostActivateDescriptors());
            if(ejbSessionDescriptor.hasPrePassivateMethod())
                callbackDescs.addAll(ejbSessionDescriptor.getPrePassivateDescriptors());
        }

        for (LifecycleCallbackDescriptor callbackDesc : callbackDescs) {
            try {
                Method method = callbackDesc.getLifecycleCallbackMethodObject(cl);
                Class[] excepClasses = method.getExceptionTypes();
                for (Class exception : excepClasses) {
                    if(!(RuntimeException.class.isAssignableFrom(exception) ||
                            java.rmi.RemoteException.class.isAssignableFrom(exception))) {
                        addErrorDetails(result, compName);
                        result.failed(smh.getLocalString
                                        (getClass().getName() + ".failed",
                                        "Method [ {0} ] throws an application exception.",
                                        new Object[] {method}));
                    }
                }
            } catch (Exception e) {}// will be caught in other tests
        }
        
        if(result.getStatus()!=Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                            (getClass().getName() + ".passed",
                            "Valid Callback methods."));
        }
        
        return result;
    }
}
