/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ejb.MethodUtils;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;

import java.lang.reflect.Method;

/**
 * The message driven bean class must implement the message listener interface 
 * or the methods of the message listener interface.
 * 
 * @author Vikas Awasthi
 */
public class MDBImplementsListenerMethods extends MessageBeanTest {
    
    public Result check(EjbMessageBeanDescriptor descriptor) {

        try {
            ClassLoader cl = getVerifierContext().getClassLoader();
            Class intfCls = Class.forName(descriptor.getMessageListenerType(), false, cl);
            Class ejbCls = Class.forName(descriptor.getEjbClassName(), false, cl);
            
            if(!intfCls.isAssignableFrom(ejbCls)) {
                Method[] methods = intfCls.getMethods();
                for (Method method : methods) {
                    boolean foundOne = false;
                    for (Method ejbMethod : ejbCls.getMethods()) {
                        if(MethodUtils.methodEquals(ejbMethod, method)) {
                            foundOne = true;
                            break;
                        }
                    }
                    if(!foundOne) {
                        addErrorDetails(result, compName);
                        result.failed(
                                smh.getLocalString(getClass().getName()+".failed",
                                "Message bean [ {0} ] neither implements listener " +
                                "interface [ {1} ] nor implements listener " +
                                "interface method [ {2} ]",
                                new Object[] {ejbCls.getSimpleName(), intfCls.getName(), method}));
                    }
                }
            }
        } catch (ClassNotFoundException e) {
            //ignore as this error will be caught by other tests
            logger.fine(descriptor.getEjbClassName() + " Not found");
        }
        
        if(result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(
                    smh.getLocalString(getClass().getName()+".passed",
                            "Valid Message bean [ {0} ]",
                            new Object[] {descriptor.getEjbClassName()}));
        }

        return result;
    }
}
