/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.EjbDescriptor;

import java.util.Set;

/**
 * Business interface of an enterprise bean must be an interface and must not be
 * defined as a class.
 * 
 * @author Vikas Awasthi
 */
public class ValidBusinessInterface extends EjbTest {

    public Result check(EjbDescriptor descriptor) {
        Result result = getInitializedResult();
        ComponentNameConstructor compName =
                            getVerifierContext().getComponentNameConstructor();
        Set<String> remoteAndLocalIntfs = descriptor.getRemoteBusinessClassNames();
        remoteAndLocalIntfs.addAll(descriptor.getLocalBusinessClassNames());

        for (String remoteOrLocalIntf : remoteAndLocalIntfs) {
            try {
                ClassLoader classLoader = getVerifierContext().getClassLoader();
                Class c = Class.forName(remoteOrLocalIntf, false, classLoader);
                if(!c.isInterface()) {
                    addErrorDetails(result, compName);
                    result.failed(smh.getLocalString
                            (getClass().getName() + ".failed",
                            "[ {0} ] is defined as a class. It should be an interface.",
                            new Object[] {c}));
                }
            } catch (ClassNotFoundException e) {
                // ignore as it will be caught in other tests
            }
        }
        
        if(result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                            (getClass().getName() + ".passed",
                            "Business Interface(s) are valid."));
        }

        return result;
    }
}
