/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;

/**
 * @author Sudipto Ghosh
 */
public class EjbNameIsValidJavaIdentifier extends EjbTest implements EjbCheck{

    /**
     * For an entity-bean the ejb-name must be a valid Java identifier.
     * See ejb specification 2.1 section 10.3.13
     * @param descriptor the Enterprise Java Bean deployment descriptor
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {
        Result result = getInitializedResult();
        String ejbName = descriptor.getName();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        if(descriptor instanceof EjbEntityDescriptor) {
            if (((EjbEntityDescriptor)descriptor).getPersistenceType().equals(EjbEntityDescriptor.CONTAINER_PERSISTENCE)) {
                boolean isJavaIdentifier=true;
                boolean startChar=Character.isJavaIdentifierStart(ejbName.charAt(0));
                if(startChar) {
                    for(int i=1;i<ejbName.length();i++)
                        if(!Character.isJavaIdentifierPart(ejbName.charAt(i))) {
                            isJavaIdentifier=false;
                            break;
                        }
                } else {
                    isJavaIdentifier=false;
                }
                //if start Character is not valid or any of the part characters of ejb-name is not
                //valid JavaIdentifier
                if(isJavaIdentifier) {
                    result.addGoodDetails(smh.getLocalString
                            ("tests.componentNameConstructor",
                                    "For [ {0} ]",
                                    new Object[] {compName.toString()}));
                    result.passed(smh.getLocalString
                            (getClass().getName() + ".passed",
                                    "ejb-name [ {0} ] within bean [ {1} ] is a valid java identifier",
                                    new Object[] {ejbName, descriptor.getName()}));
                    return result;
                } else {
                    result.addErrorDetails(smh.getLocalString
                            ("tests.componentNameConstructor",
                                    "For [ {0} ]",
                                    new Object[] {compName.toString()}));
                    result.failed(smh.getLocalString
                            (getClass().getName() + ".failed",
                                    "ejb-name [ {0} ] within bean [ {1} ] is not a valid java identifier",
                                    new Object[] {ejbName, descriptor.getName()}));
                    return result;
                }
            }
        }
        result.addNaDetails(smh.getLocalString
                ("tests.componentNameConstructor",
                        "For [ {0} ]",
                        new Object[] {compName.toString()}));
        result.notApplicable(smh.getLocalString
                (getClass().getName() + ".notApplicable",
                        "[ {0} ] expected {1} bean, with Container Managed Persistence.",
                        new Object[] {getClass(),"Entity"}));
        return result;
    }
}

