/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2;

import java.util.*;
import java.lang.reflect.Method;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.tools.verifier.tests.*;


/**
 * Check that the field type for all declated cmp fields of the entity bean
 * are of an acceptable type :
 *      - Java Primitive Type
 *      - Java Serializable class
 *      - Reference to a bean's home or bean's remote interface
 * 
 * @author  Jerome Dochez
 * @version 1.0
 */
public class CmpFields extends CmpFieldTest {
 
    /**
     * run an individual verifier test of a declated cmp field of the class
     *
     * @param entity the descriptor for the entity bean containing the cmp-field    
     * @param f the descriptor for the declared cmp field
     * @param c the class owning the cmp field
     * @parma r the result object to use to put the test results in
     * 
     * @return true if the test passed
     */    

    protected boolean runIndividualCmpFieldTest(Descriptor entity, Descriptor persistentField, Class c, Result result) {
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        String cmpFieldName = persistentField.getName();
        String getMethodName = "get" + Character.toUpperCase(cmpFieldName.charAt(0)) + cmpFieldName.substring(1);
        Method getMethod = getMethod(c, getMethodName, null);
        Class fieldType;

        if (getMethod != null) {
	    boolean run = false;
            // get the return type for the setMethod
            fieldType = getMethod.getReturnType();
	    EjbBundleDescriptor bundle = ((EjbDescriptor) entity).getEjbBundleDescriptor();
	    if (!RmiIIOPUtils.isValidRmiIDLPrimitiveType(fieldType) &&
		!EjbUtils.isValidSerializableType(fieldType)) {
		// it must be a reference to a bean's home or local interface
		if (!isValidInterface(fieldType, bundle.getEjbs(),MethodDescriptor.EJB_REMOTE, result)) {
		     result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		    result.addErrorDetails(smh.getLocalString
			   (getClass().getName() + ".failed",
			   "Error : Invalid type assigned for container managed field [ {0} ] in bean [ {1} ]",
			    new Object[] {((Descriptor)persistentField).getName(),entity.getName()}));
		    return false;
		}
		if (!isValidInterface(fieldType, bundle.getEjbs(),MethodDescriptor.EJB_LOCAL, result)) {
		     result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		    result.addErrorDetails(smh.getLocalString
			      (getClass().getName() + ".failed",
			       	"Error : Invalid type assigned for container managed field [ {0} ] in bean [ {1} ]",
				new Object[] {((Descriptor)persistentField).getName(),entity.getName()}));
				return false;
		}
	    }   
	    result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()})); 
	    result.addGoodDetails(smh.getLocalString
		   (getClass().getName() + ".passed",
		    "Valid type assigned for container managed field [ {0} ] in bean [ {1} ]",
		    new Object[] {((Descriptor)persistentField).getName(),entity.getName()}));
	    run = true;  
	    return run;
	    
        } else {
	    result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
            result.addErrorDetails(smh.getLocalString
		("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.isAccessorDeclared.failed2",
		 "Error : Cannot find accessor [ {0} ] method for [ {1} ] field ",
		 new Object[] {getMethodName , persistentField.getName()}));       
        }
        return false;
    }

    private boolean isValidInterface(Class fieldType, Set entities,String interfaceType, Result result) {
	try {  
        if (entities==null)
            return false;
        
        Iterator iterator = entities.iterator();
	if(interfaceType.equals(MethodDescriptor.EJB_REMOTE)) {
	    while (iterator.hasNext()) {
		EjbAbstractDescriptor entity = (EjbAbstractDescriptor) iterator.next();
		
		if (fieldType.getName().equals(entity.getHomeClassName()) ||
		    fieldType.getName().equals(entity.getRemoteClassName()))
		    return true;
	    }
	}
	if(interfaceType.equals(MethodDescriptor.EJB_LOCAL)) {
	    while (iterator.hasNext()) {
		EjbAbstractDescriptor entity = (EjbAbstractDescriptor) iterator.next();
		
		if (fieldType.getName().equals(entity.getLocalHomeClassName()) ||
		    fieldType.getName().equals(entity.getLocalClassName()))
		    return true;
	    }
	}
        return false;
	}catch(Throwable t) {
	    result.addErrorDetails(smh.getLocalString
			      (getClass().getName() + ".failed",
			       	"Error occured in accessing remote/local interface",
				new Object[] {}));
	    return false;
	}
    }
}
