/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2;

import java.lang.reflect.Method;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

/**
 * EJB 2.0 Spec 9.4.11 CMR accessor methods for relationships
 *  between entity beans should not be exposed in the remote interface
 * 
 * @author  Jerome Dochez
 * @version 
 */
public class CmrFieldsAccessorExposition extends CmrFieldTest {

   /**
     * run an individual verifier test of a declated cmr field of the class
     *
     * @param entity the descriptor for the entity bean containing the cmp-field    
     * @param info the descriptor for the declared cmr field
     * @param c the class owning the cmp field
     * @parma r the result object to use to put the test results in
     * 
     * @return true if the test passed
     */            
    protected boolean runIndividualCmrTest(Descriptor descriptor, RelationRoleDescriptor rrd, Class c, Result result) {
        
        // check first if this is one-to-one or many-to-one relationship ...previous version of ejb specs
	//   if ((!rrd.getIsMany() && !rrd.getPartner().getIsMany()) ||
	//     (rrd.getIsMany() && !rrd.getPartner().getIsMany())) {                
	    //  }
        // everyone falls back and should be checked

        boolean pass = true;
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
      
        // should not have accessor methods exposed. 
       	if (((EjbDescriptor)descriptor).getRemoteClassName() != null && 
	    !((((EjbDescriptor)descriptor).getRemoteClassName()).equals(""))) {
	    String interfaceType = ((EjbDescriptor)descriptor).getRemoteClassName();
	    try {             
		CMRFieldInfo info = rrd.getCMRFieldInfo();
		Class remoteInterface = Class.forName(interfaceType, false, getVerifierContext().getClassLoader());
		String getMethodName = "get" + Character.toUpperCase(info.name.charAt(0)) + info.name.substring(1);        
		String setMethodName = "set" + Character.toUpperCase(info.name.charAt(0)) + info.name.substring(1);        
		
		Method getMethod = getMethod(remoteInterface, getMethodName, null);
		if (getMethod != null) {
            addErrorDetails(result, compName);
		    result.addErrorDetails(smh.getLocalString
		    ("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CmrFieldsAccessorExposition.failed",
		     "Error : CMR field {0} accessor method [ {1} ] is exposed through the component interface [ {2} ]",
		     new Object[] {"get", info.name, interfaceType}));     
		    pass = false;
		} else {
		     result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		    result.addGoodDetails(smh.getLocalString
			("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CmrFieldsAccessorExposition.passed",
			 "CMR field {0} accessor method [ {1} ] is not exposed through the component interface [ {2} ]",
			 new Object[] {"get", info.name, interfaceType}));        
		    pass = true;           
		}
		
		Class parms[] = { info.type };
		Method setMethod = getMethod(remoteInterface, setMethodName, parms );        
		if (setMethod != null) {
            addErrorDetails(result, compName);
		    result.addErrorDetails(smh.getLocalString
		       ("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CmrFieldsAccessorExposition.failed",
		       "Error : CMR field {0} accessor method [ {1} ] is exposed through the component interface [ {2} ]",
			new Object[] {"set", info.name, interfaceType}));   
		    
		    pass = false;
		} else {
		     result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		    result.addGoodDetails(smh.getLocalString
			("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CmrFieldsAccessorExposition.passed",
			 "CMR field [{0}] accessor method [ {1} ] is not exposed through the component interface [ {2} ]",
			 new Object[] {"set", info.name, interfaceType}));                    
		}  
		
	    } catch (Exception e) {
		Verifier.debug(e);
        addErrorDetails(result, compName);
		result.addErrorDetails(smh.getLocalString
			      ("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CmrFieldsAccessorExposition.failedException",
			       "Error:  [{0}] class not found or local interface not defined",
			       new Object[] {interfaceType}));
		pass = false;
	
	    }                 
	} 
        return pass;        
    }
}
