/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbfindermethod;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.*;

/** 
 * Note that the ejbFind<METHOD> names and parameter signatures do not 
 * provide the container tools with sufficient information for automatically 
 * generating the implementation of the finder methods for methods other than 
 * ejbFindByPrimaryKey. Therefore, the bean provider is responsible for 
 * providing a description of each finder method. The entity bean Deployer 
 * uses container tools to generate the implementation of the finder methods 
 * based in the description supplied by the bean provider. The Enterprise 
 * JavaBeans architecture does not specify the format of the finder method 
 * description.
 */
public class EjbFinderMethodDescription extends EjbTest implements EjbCheck { 


    /**
     * Note that the ejbFind<METHOD> names and parameter signatures do not 
     * provide the container tools with sufficient information for automatically 
     * generating the implementation of the finder methods for methods other than 
     * ejbFindByPrimaryKey. Therefore, the bean provider is responsible for 
     * providing a description of each finder method. The entity bean Deployer 
     * uses container tools to generate the implementation of the finder methods 
     * based in the description supplied by the bean provider. The Enterprise 
     * JavaBeans architecture does not specify the format of the finder method 
     * description.
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();

	// Stub test class placeholder
	// fill in guts/logic - pass/fail accordingly in future
	result.setStatus(Result.NOT_IMPLEMENTED);
	result.addNaDetails
	    (smh.getLocalString
	     (getClass().getName() + ".notImplemented",
	      "No static testing done - yet."));
	return result;
    }
}
