/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.homeintf.remotehomeintf;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;

/**
 * Home Interface follows the standard rules for RMI-IIOP remote interfaces 
 * test.  
 *
 * All enterprise beans home interface's must follow the standard rules 
 * for RMI-IIOP remote interfaces.
 */
public class RemoteHomeInterfaceRmiIIOP extends EjbTest implements EjbCheck { 


    /** 
     * Home Interface follows the standard rules for RMI-IIOP remote interfaces 
     * test.  
     *
     * All enterprise beans home interface's must follow the standard rules 
     * for RMI-IIOP remote interfaces.
     *   
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
	
	if(descriptor.getHomeClassName() == null || "".equals(descriptor.getHomeClassName())) {
            addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString
                       ("com.sun.enterprise.tools.verifier.tests.ejb.localinterfaceonly.notapp",
                        "Not Applicable because, EJB [ {0} ] has Local Interfaces only.",
                                          new Object[] {descriptor.getEjbClassName()}));

	    return result;
	}
	
	if ((descriptor instanceof EjbSessionDescriptor) ||
	    (descriptor instanceof EjbEntityDescriptor)) {
 
	    try {
		ClassLoader jcl = getVerifierContext().getClassLoader();
		Class c = Class.forName(descriptor.getHomeClassName(), false, jcl);

		// remote interface must be defined as valid Rmi-IIOP remote interface
		boolean isValidRmiIIOPInterface = false;
		if (RmiIIOPUtils.isValidRmiIIOPInterface(c) && RmiIIOPUtils.isValidRmiIIOPInterfaceMethods(c)) {
		    isValidRmiIIOPInterface = true;
		}
 
		// remote interface must be defined as valid Rmi-IIOP remote interface
		if (!isValidRmiIIOPInterface){
		    addErrorDetails(result, compName);
		    result.failed(smh.getLocalString
				  (getClass().getName() + ".failed",
				   "Error: [ {0} ] is not defined as valid RMI-IIOP remote interface.  All enterprise beans home interfaces must be defined as valid RMI-IIOP remote interface.  [ {1} ] is not a valid remote home interface.",
				   new Object[] {descriptor.getHomeClassName(),descriptor.getHomeClassName()}));
		} else {
		    addGoodDetails(result, compName);
		    result.passed(smh.getLocalString
				  (getClass().getName() + ".passed",
				   "[ {0} ] properly declares the home interface as valid RMI-IIOP remote interface.",
				   new Object[] {descriptor.getHomeClassName()}));
		}
	    } catch (ClassNotFoundException e) {
		Verifier.debug(e);
		addErrorDetails(result, compName);
		result.failed(smh.getLocalString
			      (getClass().getName() + ".failedException",
			       "Error: [ {0} ] class not found.",
			       new Object[] {descriptor.getHomeClassName()}));
	    }  
	    return result;
 
	} else {
	    addNaDetails(result, compName);
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "[ {0} ] expected {1} bean or {2} bean, but called with {3}.",
				  new Object[] {getClass(),"Session","Entity",descriptor.getName()}));
	    return result;
	}
    }
}
