/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.intf.remoteintf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.tests.ejb.intf.InterfaceMatchMethodException;

/** 
 * Remote interface/business matching methods exceptions test.  
 * Verify the following:
 * 
 *   For each method defined in the remote interface, there must be a matching 
 *   method in the enterprise Bean's class. The matching method must have: 
 *   . All the exceptions defined in the throws clause of the matching method 
 *     of the enterprise Bean class must be defined in the throws clause of 
 *     the method of the remote interface. 
 * @author Sheetal Vartak
 */
public class RemoteInterfaceMatchMethodException extends InterfaceMatchMethodException { 
    
    protected String getInterfaceName(EjbDescriptor descriptor) {
        return descriptor.getRemoteClassName();
    }
    
    protected String getInterfaceType() {
        return MethodDescriptor.EJB_REMOTE;
    }
}
