package com.sun.enterprise.tools.verifier.tests.ejb.runtime;

/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
/** ejb [1,n]
 *    name [String]
 *
 * This is the name of the enterprise java bean.
 * @author
 */
public class ASEjbName extends EjbTest implements EjbCheck {

    /**
     * @param descriptor the Enterprise Java Bean deployment descriptor
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

        boolean oneFailed = false;
	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        try{
            String ejbName = descriptor.getName();
            if(ejbName.length()==0){
                addErrorDetails(result, compName);
                result.failed(smh.getLocalString
                    (getClass().getName() + ".failed",
                    "failed [AS-EJB ejb] : ejb-name cannot not be empty. It should be a valid ejb-name as defined in ejb-jar.xml"));
            } else {
                EjbDescriptor testDesc = descriptor.getEjbBundleDescriptor().getEjbByName(ejbName);
                if(testDesc!=null && testDesc.getName().equals(ejbName))
                {
                    addGoodDetails(result, compName);
                    result.passed(smh.getLocalString(getClass().getName() + ".passed",
                        "PASSED [AS-EJB ejb] :  ejb-name is {0} and verified with ejb-jar.xml",
                        new Object[] {ejbName}));
                }
                else
                {
                    addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(getClass().getName() + ".failed1",
                        "FAILED [AS-EJB ejb] :  ejb-name {0} is not found in ejb-jar.xml. It should exist in ejb-jar.xml also.",
                        new Object[] {ejbName}));
                }
            }
        } catch(Exception ex){
            oneFailed = true;
            addErrorDetails(result, compName);
            result.addErrorDetails(smh.getLocalString
                 (getClass().getName() + ".notRun",
                  "NOT RUN [AS-EJB] : Could not create descriptor object"));
        }
        return result;
    }
}
